<?php
// event.pt.php

/**
 * Use namespace to avoid conflict
 */
namespace PostType;

/**
 * Class Listing_Dealer
 * @package PostType
 *
 * Use actual name of post type for
 * easy readability.
 *
 * Potential conflicts removed by namespace
 */
class Listing_Dealer {

	/**
	 * @var string
	 *
	 * Set post type params
	 */
	private $type               = 'listing_dealer';
	private $slug               = 'listing-dealer';
	private $name               = 'Listing Dealer';
	private $singular_name      = 'Listing Dealer';
	private $icon               = 'dashicons-businessman';

	/**
	 * Register post type
	 */
	public function register() {
		$slug = $this->slug;

		$labels = array(
			'name'                  => esc_html_x( 'listing Dealer', 'Post Type General Name', 'autohive-core' ),
			'singular_name'         => esc_html_x( 'listing Dealer', 'Post Type Singular Name', 'autohive-core' ),
			'add_new'               => esc_html__( 'Add New', 'autohive-core' ),
			'add_new_item'          => esc_html__( 'Add New', 'autohive-core' ) . $this->singular_name,
			'edit_item'             => esc_html__( 'Edit ', 'autohive-core' ) . $this->singular_name,
			'new_item'              => esc_html__( 'New ', 'autohive-core' ) . $this->singular_name,
			'all_items'             => esc_html__( 'All Listing Dealer', 'autohive-core'),
			'view_item'             => esc_html__( 'View ', 'autohive-core' ) . $this->singular_name,
			'view_items'            => esc_html__( 'View ', 'autohive-core' ) . $this->name,
			'search_items'          => esc_html__( 'Search ', 'autohive-core' ) . $this->name,
			'not_found'             => esc_html__( 'No ', 'autohive-core' ) . strtolower($this->name) . esc_html__( ' found', 'autohive-core'),
			'not_found_in_trash'    => esc_html__( 'No ', 'autohive-core' ) . strtolower($this->name) .  esc_html__( ' found in Trash', 'autohive-core'),
			'parent_item_colon'     => '',
			'menu_name'             => $this->name,
		);

		$args = array(
			'labels'                => $labels,
			'public'                => true,
			'publicly_queryable'    => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'query_var'             => true,
			'rewrite'               => array( 'slug' => $slug ),
			'capability_type'       => 'post',
			'has_archive'           => false,
			'hierarchical'          => true,
			'menu_position'         => 8,
			'supports'              => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'elementor', 'comments'),
			'yarpp_support'         => true,
			'menu_icon'             => $this->icon
		);

		register_post_type( $this->type, $args );

		register_taxonomy($this->type.'_cat', $this->type, array(
			'public'                => true,
			'hierarchical'          => true,
			'show_admin_column'     => true,
			'show_in_nav_menus'     => false,
			'labels'                => array(
				'name'  => esc_html__( 'Categories', 'autohive-core'),
			)
		));
		
		
	}

	/**
	 * @param $columns
	 * @return mixed
	 *
	 * Choose the columns you want in
	 * the admin table for this post
	 */
	public function set_columns($columns) {
		// Set/unset post type table columns here

		return $columns;
	}

	/**
	 * @param $column
	 * @param $post_id
	 *
	 * Edit the contents of each column in
	 * the admin table for this post
	 */
	public function edit_columns($column, $post_id) {
		// Post type table column content code here
	}

	/**
	 * Listing_Dealer constructor.
	 *
	 * When class is instantiated
	 */
	public function __construct() {

		// Register the post type
		add_action( 'init', array($this, 'register'));

		// Admin set post columns
		add_filter( 'manage_edit-'.$this->type.'_columns',        array($this, 'set_columns'), 10, 1) ;

		// Admin edit post columns
		add_action( 'manage_'.$this->type.'_posts_custom_column', array($this, 'edit_columns'), 10, 2 );

	}

}

/**
 * Instantiate class, creating post type
 */
new Listing_Dealer();