<?php
//Add Image Size
add_image_size('autohive_100x100', 100, 100, true); // Dealer thumb
add_image_size('autohive_740x565', 550, 420, true); // Listing 01
add_image_size('autohive_500x250', 500, 250, true); // Blog Grid 01
add_image_size('autohive_314x251', 314, 251, true); // Blog Product Carousel 01
add_image_size('autohive_416x370', 416, 370, true); // Blog Grid 02
add_image_size('autohive_520x445', 520, 445, true); // Blog Masonry 03
add_image_size('autohive_520x520', 520, 520, true); // Blog Masonry 03
add_image_size('listing_810x490', 810, 490, true); // autohive_listing_details_thumb
add_image_size('listing_185x122', 185, 122, true); // autohive_listing_details_thumb
add_image_size('autohive_636x330', 636, 330, true); // Promo Slider 01
add_image_size('autohive_525x310', 525, 310, true); // Dealer Grid 01
add_image_size('autohive_72x72', 72, 72, true); // Dealer Recent Post 03
add_image_size('autohive_274x194', 274, 194, true); // Dealer 04
add_image_size('autohive_636x344', 636, 344, true); // Testimonial 02
add_image_size('autohive_80x80', 80, 80, true); // Testimonial 02
add_image_size('autohive_rent_115x70', 115, 70, true); // Rent Post Slider
add_image_size('autohive_rent_675x540', 675, 540, true); // Rent Post Slider
add_image_size('autohive_88x88', 88, 88, true); // Testimonial 03
add_image_size('autohive_rent_760x580', 760, 580, true); // Rent Related post carousel
add_image_size('dealer_280x250', 280, 250, true); // Dealer Single Thumbnails
add_image_size('rent_520x350', 520, 350, true); // Rental List Thumbnails


function autohive_addons_get_contact_form7_forms() {
    $forms = get_posts('post_type=wpcf7_contact_form&posts_per_page=-1');

    $results = array();
    if ($forms) {
        $results[] = __('Select A Form', 'autohive-core');
        foreach ($forms as $form) {
            $results[$form->ID] = $form->post_title;
        }
    } else {
        $results[] =  __('No contact forms found', 'autohive-core');
    }

    return $results;
}


//Add extra profile information
add_action('show_user_profile', 'plugin_name_extra_user_profile_fields');
add_action('edit_user_profile', 'plugin_name_extra_user_profile_fields');

function plugin_name_extra_user_profile_fields($user)
{ ?>
    <h3><?php esc_html_e("Extra profile information", 'autohive-core'); ?></h3>

    <table class="form-table">
        <tr>
            <th><label for="facebook"><?php esc_html_e("Facebook", 'autohive-core'); ?></label></th>
            <td>
                <input type="text" name="facebook" id="facebook" value="<?php echo esc_attr(get_the_author_meta('facebook', $user->ID)); ?>" class="regular-text" /><br />
                <span class="description"><?php esc_html_e("Please enter your facebook url.", 'autohive-core'); ?></span>
            </td>
        </tr>
        <tr>
            <th><label for="twitter"><?php esc_html_e("Twitter", 'autohive-core'); ?></label></th>
            <td>
                <input type="text" name="twitter" id="twitter" value="<?php echo esc_attr(get_the_author_meta('twitter', $user->ID)); ?>" class="regular-text" /><br />
                <span class="description"><?php esc_html_e("Please enter your twitter url.", 'autohive-core'); ?></span>
            </td>
        </tr>
        <tr>
            <th><label for="linkedin"><?php esc_html_e("Linkedin", 'autohive-core'); ?></label></th>
            <td>
                <input type="text" name="linkedin" id="linkedin" value="<?php echo esc_attr(get_the_author_meta('linkedin', $user->ID)); ?>" class="regular-text" /><br />
                <span class="description"><?php esc_html_e("Please enter your linkedin url.", 'autohive-core'); ?></span>
            </td>
        </tr>

        <tr>
            <th><label for="instagram"><?php esc_html_e("Instagram", 'autohive-core'); ?></label></th>
            <td>
                <input type="text" name="instagram" id="instagram" value="<?php echo esc_attr(get_the_author_meta('instagram', $user->ID)); ?>" class="regular-text" /><br />
                <span class="description"><?php esc_html_e("Please enter your instagram url.", 'autohive-core'); ?></span>
            </td>
        </tr>
    </table>
<?php }

add_action('personal_options_update', 'plugin_name_save_extra_user_profile_fields');
add_action('edit_user_profile_update', 'plugin_name_save_extra_user_profile_fields');

function plugin_name_save_extra_user_profile_fields($user_id)
{
    if (!current_user_can('edit_user', $user_id)) {
        return false;
    }
    update_user_meta($user_id, 'instagram', $_POST['instagram']);
    update_user_meta($user_id, 'facebook', $_POST['facebook']);
    update_user_meta($user_id, 'linkedin', $_POST['linkedin']);
    update_user_meta($user_id, 'twitter', $_POST['twitter']);
}

/** Autohive Kses Post */
if (!function_exists('autohive_kses_post')) {
    function autohive_kses_post($content)
    {
        $allowed_tag = array(
            'strong' => [],
            'p'      => [],
            'span'   => [
                'class' => [],
                'style' => []
            ],
            'br'     => [],
            'a'      => [
                'href'  => [],
                'class' => [],
            ],
            'img'      => [
                'src'   => [],
                'srcset' => [],
                'width' => [],
                'height' => [],
                'class' => [],
                'alt'   => [],
            ],
            'div'   => [
                'class' => [],
                'style' => []
            ],
            'h1'    => [
                'class' => [],
                'style' => []
            ],
            'h2'    => [
                'class' => [],
                'style' => []
            ],
            'h3'    => [
                'class' => [],
                'style' => []
            ],
            'h4'    => [
                'class' => [],
                'style' => []
            ],
            'h5'    => [
                'class' => [],
                'style' => []
            ],
            'h6'    => [
                'class' => [],
                'style' => []
            ],
            'mark'    => [
                'class' => [],
                'style' => []
            ],
            'sup'    => [
                'class' => [],
                'style' => []
            ],
            'sub'    => [
                'class' => [],
                'style' => []
            ],
        );
        return wp_kses($content, $allowed_tag);
    }
}

// Tab Return Data
function return_tab_data($getCats, $event_schedule_cats, $tab_title)
{
    $y = [];
    foreach ($getCats as $val) {

        $t = [];
        foreach ($event_schedule_cats as $data) {
            if ($data[$tab_title] == $val) {
                $t[] = $data;
            }
        }
        $y[$val] = $t;
    }

    return $y;
}

// Category array
function autohive_cat_array($term = 'category')
{
    $cats = get_terms(array(
        'taxonomy' => $term,
        'hide_empty' => true
    ));
    $cat_array = array();
    foreach ($cats as $cat) {
        $cat_array[$cat->slug] = $cat->name;
    }
    return $cat_array;
}

// Post Time Ago
function autohive_get_post_time_ago()
{
    return human_time_diff(get_the_time('U'), current_time('timestamp')) . esc_html__(' ago', 'autohive-core');
}



/* Contact Form Content Filter */
add_filter('wpcf7_form_elements', function ($content) {
    $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);

    return $content;
});




/**
 * Elementor Title tags
 */
function autohive_el_title_tags()
{
    return [
        'h1'   => 'H1',
        'h2'   => 'H2',
        'h3'   => 'H3',
        'h4'   => 'H4',
        'h5'   => 'H5',
        'h6'   => 'H6',
        'div'  => 'div',
        'span' => 'span',
        'p'    => 'p',
    ];
}



/**
 * @param $settings
 * @param $settings_key
 * @return string
 */
function autohive_el_ratting($settings, $settings_key) {
    for ($i = 1; $i <= 5; $i++) {
        if ($i > $settings[$settings_key]) {
            echo '<li><i class="fa-regular fa-star"></i></li>';
        } else {
            echo '<li><i class="fas fa-star"></i></li>';
        }
    }
}


/**
 * Elementor Ratting
 */
function autohive_el_ratting_options() {
	return [
		'1' => __('1 Star', 'autohive-core'),
		'2' => __('2 Star', 'autohive-core'),
		'3' => __('3 Star', 'autohive-core'),
		'4' => __('4 Star', 'autohive-core'),
		'5' => __('5 Star', 'autohive-core'),
	];
}



function autohive_el_text_alignment()
{

    $choose_alignment = [
        'left' => [
            'title' => __('Left', 'autohive-core'),
            'icon' => 'eicon-text-align-left',
        ],
        'center' => [
            'title' => __('Center', 'autohive-core'),
            'icon' => 'eicon-text-align-center',
        ],
        'right' => [
            'title' => __('Right', 'autohive-core'),
            'icon' => 'eicon-text-align-right',
        ],
    ];

    return $choose_alignment;
}


/**
 * @param $mimes
 * Support SVG Image
 * @return mixed
 */
function autohive_mime_types($mimes)
{
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'autohive_mime_types');


/**
 * Listing Meta
 */
function autohive_listing_meta($meta_key)
{
    $args = array(
        'post_type' => 'autohive_listing',
        'posts_per_page' => -1,

    );
    $postslist = get_posts($args);
    $metaList = array();
    foreach ($postslist as $key => $item) {

        $meta = get_post_meta($item->ID, $meta_key, true);
        $metaList[$key] = $meta;
    }

    $metaList = array_unique($metaList);
    if (is_array($metaList)) {
        foreach ($metaList as $type) {
            echo '<li><label><input type="checkbox" name="' . esc_attr($meta_key) . '" value="' . esc_attr($type) . '"><span class="ct-checkbox me-2"><i class="fa-solid fa-check"></i></span>' . esc_html($type) . '</label></li>';
        }
    }
}


/**
 * Listing Meta array
 */
function autohive_listing_meta_features()
{

    $meta_items = [
        'car_body_type'     => __('Car Body Type', 'autohive'),
        'car_model'         => __('Car Model', 'autohive'),
        'mileage'           => __('Mileage', 'autohive'),
        'car_transmissions' => __('Car Transmissions', 'autohive'),
        'car_engine_size'   => __('Car Engine Size', 'autohive'),
        'fuel_type'         => __('Fuel Type', 'autohive'),
        'condition'         => __('Condition', 'autohive'),
        'build_year'        => __('Build Year', 'autohive'),
        'drivetrian'        => __('Drivetrian', 'autohive'),
        'car_color'         => __('Car Color', 'autohive'),
        'cylinders'         => __('Engine Cylinders', 'autohive'),
        'car_vin'           => __('VIN', 'autohive'),
        'car_doors'         => __('Doors', 'autohive'),
    ];

    return $meta_items;
}


// Register Custom Taxonomy
function autohive_product_taxonomy()
{
    $labels = array(
        'name'                       => __('Brands', 'autohive'),
        'singular_name'              => __('Brand', 'autohive'),
        'menu_name'                  => __('Brands', 'autohive'),
        'all_items'                  => __('All Brands', 'autohive'),
        'parent_item'                => __('Parent Brand', 'autohive'),
        'parent_item_colon'          => __('Parent Brand:', 'autohive'),
        'new_item_name'              => __('New Brand Name', 'autohive'),
        'add_new_item'               => __('Add New Brand', 'autohive'),
        'edit_item'                  => __('Edit Brand', 'autohive'),
        'update_item'                => __('Update Brand', 'autohive'),
        'separate_items_with_commas' => __('Separate Brand with commas', 'autohive'),
        'search_items'               => __('Search Brands', 'autohive'),
        'add_or_remove_items'        => __('Add or remove Brands', 'autohive'),
        'choose_from_most_used'      => __('Choose from the most used Brands', 'autohive'),
    );
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
    );
    register_taxonomy('product_brand', 'product', $args);
}
add_action('init', 'autohive_product_taxonomy');


/**
 * Autohive product query function
 *
 * @param [type] $q
 * @return void
 */
function autohive_product_query($q)
{

    $car_brand     = !empty($_GET['brand']) ? sanitize_text_field($_GET['brand']) : '';
    $build_year    = !empty($_GET['buildyear']) ? sanitize_text_field($_GET['buildyear']) : '';
    $car_model     = !empty($_GET['carmodel']) ? sanitize_text_field($_GET['carmodel']) : '';
    $car_parts     = !empty($_GET['keyword']) ? sanitize_text_field($_GET['keyword']) : ''; 

    $q->get('tax_query');
    $q->get('meta_query');
    $tax_args[] = '';
    $meta_args[] = '';

    if (!empty($car_brand)) {
        $tax_args['tax_query'] = array(
            [
                'taxonomy' => 'product_brand',
                'field' => 'slug',
                'terms' => $car_brand
            ]
        );
    }

    if ( !empty( $build_year || $car_model || $car_parts )) {

        $buildYear_arr  = !empty($build_year) ? ['key' => 'buildYear', 'value'   => $build_year ] : '';
        $carModel_arr   = !empty($car_model) ? ['key' => 'carModel', 'value'   => $car_model ] : '';
        $carParts_arr   = !empty($car_parts) ? ['key' => 'partsNumber', 'value'   => $car_parts ] : '';

        $meta_args['meta_query'] = array(
            $buildYear_arr,
            $carModel_arr,
            $carParts_arr
        );
    }

    $q->set('tax_query', $tax_args);
    $q->set('meta_query', $meta_args);
}
add_action('woocommerce_product_query', 'autohive_product_query');


function autohive_swiper_breakpoint( $desktop = 3, $tablet = 2, $mobile_extra = 1, $mobile = 1) {

    $breakpoint = '{
        "1200": {"slidesPerView": '. esc_attr($desktop) .'},
        "991": {"slidesPerView": '. esc_attr($tablet) .'}, 
        "767": {"slidesPerView": '. esc_attr($mobile_extra) .'}, 
        "575": {"slidesPerView": '. esc_attr($mobile) .'} 
     }';

    return $breakpoint;

}



/**
 * Post Like
 * Ajax Response
 */
add_action( 'wp_ajax_pt_like_it', 'autohive_pt_like_it' );
add_action( 'wp_ajax_nopriv_pt_like_it', 'autohive_pt_like_it' );
function autohive_pt_like_it() {

	if ( ! wp_verify_nonce( $_REQUEST['nonce'], 'pt_like_it_nonce' ) || ! isset( $_REQUEST['nonce'] ) ) {
		exit( "No naughty business please" );
	}

	$likes = get_post_meta( $_REQUEST['post_id'], '_pt_likes', true );
	$likes = ( empty( $likes ) ) ? 0 : $likes;
	$new_likes = $likes + 1;

	update_post_meta( $_REQUEST['post_id'], '_pt_likes', $new_likes );

	if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
		echo $new_likes;
		die();
	}
	else {
		wp_redirect( get_permalink( $_REQUEST['post_id'] ) );
		exit();
	}
}


function autohive_like_it_button_html( $post_id, $btn_class = '', $count_text = false ) {

    $idsInLocalStorage = isset($_COOKIE["likedItems"]) ? json_decode($_COOKIE["likedItems"]) : [];

	$like_text = '';
    $nonce = wp_create_nonce('pt_like_it_nonce');
    $likes = get_post_meta($post_id, '_pt_likes', true);
    $likes = (empty($likes)) && $likes <= 1 ? __('0 Like', 'autohive-core') : $likes . __(' Likes', 'autohive-core');
    $icon  = '<i class="fa-regular fa-heart"></i>';
    $likeCount = $count_text == true ? '<span id="like-count-' . $post_id . '" class="like-count ms-1">' . $likes . '</span>' : '';

    if ( in_array( $post_id, $idsInLocalStorage ) == 1 ) {
        $like_text = '<a href="javascript:void(0);" class="liked-button ' . esc_attr($btn_class) . '"><i class="fa-solid fa-heart"></i>' . $likeCount . '</a>';
    }
    else{
        $like_text = '<a href="javascript:void(0);" class="like-button ' . esc_attr($btn_class) . '"  data-id="' . $post_id . '" data-nonce="' . $nonce . '">' . $icon . $likeCount . '</a>';
    }

	return $like_text;
}


/**
 * autohive_listing_rent_meta function
 *
 * @param string $meta_key
 * @return void
 */
function autohive_listing_rent_meta( $meta_key = 'pickup_loacation' ) {
    $args = array(
        'post_type' => 'autohive_rent',
        'posts_per_page' => -1,
        

    );
    $postslist = get_posts($args);
    $bodyType = array();
    foreach ($postslist as $key => $item) {

        $meta = get_post_meta($item->ID, $meta_key, true);
        if( !empty( $meta ) ) {
            $bodyType[] = $meta;
        }
    }
    $bodyType = array_unique( $bodyType );
    return $bodyType;
}