<?php
if ( !defined( 'ABSPATH') )
	die( '-1');

/**
 * name: Autohive_Enqueue_Scripts | Class
 * Enqueue Scripts
 */

class Autohive_Enqueue_Scripts {

    private static $_instance = null;
    public static function instance() {

        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }

        return self::$_instance;

    }

    public function __construct() {
        add_action( 'plugins_loaded', [ $this, 'on_plugins_loaded' ] );
    }

    public function on_plugins_loaded() {
        add_action( 'init', [$this, 'register_scripts'] );
    }

    public function register_scripts () {

        // Register Widget Style's
        add_action( 'elementor/frontend/before_enqueue_styles', [ $this, 'elementor_register_widget_styles' ] );
        add_action( 'elementor/editor/before_enqueue_styles', [ $this, 'elementor_register_widget_styles' ] );

        // Register Widget Script's
        add_action( 'elementor/frontend/after_register_scripts', [ $this, 'elementor_register_widget_scripts' ] );
        add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'elementor_register_widget_scripts' ] );

		// Register Elementor Preview Editor Script's
        add_action( 'elementor/frontend/after_enqueue_scripts', [ $this, 'enqueue_elementor_scripts' ]);
        add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'enqueue_elementor_scripts' ]);

		// Enqueue Scripts
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );

    }

    /**
     * Register Widget Scripts
     *
     * Register custom style required to run Autohive Core.
     *
     * @access public
     */
    function elementor_register_widget_styles() {

	    /**
	     * Register Style's
	     */
        wp_register_style( 'swiper', AUTOHIVE_CORE_DIR_VEND . '/swiper/swiper.min.css');
        wp_register_style( 'slick', AUTOHIVE_CORE_DIR_VEND . '/slick/css/slick.css');
        wp_register_style( 'custom-scrollbar', AUTOHIVE_CORE_DIR_VEND . '/custom-scrollbar/custom-scrollbar.css');
        wp_register_style( 'magnific-popup', AUTOHIVE_CORE_DIR_VEND . '/magnific-popup/magnific-popup.css');


	    /**
	     * Enqueue Style's
	     */
	    wp_enqueue_style( 'autohive-override-elementor', AUTOHIVE_CORE_DIR_CSS . '/override-elementor.css');
	    

    }


    /**
     * Register Widget Scripts
     *
     * Register custom scripts required to run Autohive Core.
     *
     * @access public
     */
    function elementor_register_widget_scripts() {

        wp_register_script( 'isotop', AUTOHIVE_CORE_DIR_VEND . '/isotop/isotop.min.js', ['jquery'], '3.0.6', true );
	    wp_register_script( 'moment-time', AUTOHIVE_CORE_DIR_VEND . '/countdown/moment.min.js', ['jquery'], AUTOHIVE_CORE_VERSION, true );
	    wp_register_script( 'date-picker', AUTOHIVE_CORE_DIR_VEND . '/countdown/date-picker.min.js', ['jquery'], AUTOHIVE_CORE_VERSION, true );
	    wp_register_script( 'countdown', AUTOHIVE_CORE_DIR_VEND . '/countdown/countdown.min.js', ['jquery'], '1.0.2', true );
	    wp_register_script( 'swiper', AUTOHIVE_CORE_DIR_VEND . '/swiper/swiper.min.js', ['jquery'], '8.3.1', true );
	    wp_register_script( 'slick', AUTOHIVE_CORE_DIR_VEND . '/slick/js/slick.min.js', ['jquery'], AUTOHIVE_CORE_VERSION, true );
        wp_register_script( 'magnific-popup', AUTOHIVE_CORE_DIR_VEND . '/magnific-popup/magnific-popup.js', ['jquery'], '1.1.0', true );
        wp_register_script( 'custom-scrollbar', AUTOHIVE_CORE_DIR_VEND . '/custom-scrollbar/custom-scrollbar.js', ['jquery'], '3.1.5 ', true );

    }

    /**
     * Register Widget Styles
     *
     * Register custom styles required to run Autohive Core.
     *
     * @access public
     */

    function enqueue_elementor_scripts() {

        wp_enqueue_script( 'autohive-elementor', AUTOHIVE_CORE_DIR_JS . '/autohive-elementor.js', [ 'jquery', 'elementor-frontend'], '1.0', true );

    }

    public function enqueue_scripts() {

	    wp_enqueue_script( 'autohive-custom', AUTOHIVE_CORE_DIR_JS . '/custom.js', array('jquery'), '1.0', true );

		wp_register_script( 'autoparts-advance-search', AUTOHIVE_CORE_DIR_JS . '/autohive-advance-search-autoparts.js', array('jquery'), '1.0', true );
		wp_localize_script( 'autoparts-advance-search', 'autoparts_advance_search', array(
            'ajax_url' => admin_url('admin-ajax.php')
        ));

        wp_register_script( 'autohive-advance-search', AUTOHIVE_CORE_DIR_JS . '/autohive-advance-search.js', array('jquery'), '1.0', true );
        wp_localize_script( 'autohive-advance-search', 'autohive_advance_search', array(
            'ajax_url' => admin_url('admin-ajax.php')
        ));

		// Ajax Call like-it
	    wp_enqueue_script( 'autohive-like-it', AUTOHIVE_CORE_DIR_JS . '/autohive-like-it.js', array('jquery'), '1.0', true );
	    wp_localize_script( 'autohive-like-it', 'autohive_like_it', array(
		    'ajax_url' => admin_url( 'admin-ajax.php' )
	    ));

        wp_enqueue_style('autohive-core-custom', AUTOHIVE_CORE_DIR_CSS . '/custom.css');

    }

}

Autohive_Enqueue_Scripts::instance();