<?php
if ( !defined('ABSPATH') ) {
	exit(); //Exit if accessed directly.
}


if ( !class_exists( 'Autohive_Core_Woo_Helper') ) {

	class Autohive_Core_Woo_Helper {


		protected static $instance = null;

		public static function instance() {

			if ( null == self::$instance ) {
				self::$instance = new Autohive_Core_Woo_Helper();
			}

			return self::$instance;

		}


		public function __construct() {
			add_action( 'woocommerce_before_shop_loop_item_title', [ 'the_display_sale_percentage', 25 ] );
			add_filter('woocommerce_add_to_cart_fragments', [ $this, 'add_to_cart_count_fragments'] );
			add_filter('wp_ajax_autohive_update_mini_cart', [ $this, 'autohive_update_mini_cart'] );
			add_filter('wp_ajax_nopriv_autohive_update_mini_cart', [ $this, 'autohive_update_mini_cart'] );
		}


		/**
		 * @return void
		 * get sale and regular price percentage
		 */
		public static function the_display_sale_percentage() {
			global $product;
			$max_percentage = 0;
			$percentage = 0;
			if ( ! $product->is_on_sale() ) return;
			if ( $product->is_type( 'simple' ) ) {
				$max_percentage = ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100;
			}
			elseif ( $product->is_type( 'variable' ) ) {
				foreach ( $product->get_children() as $child_id ) {
					$variation = wc_get_product( $child_id );
					$price = $variation->get_regular_price();
					$sale = $variation->get_sale_price();
					if ( $price != 0 && ! empty( $sale ) ) $percentage = ( $price - $sale ) / $price * 100;
					if ( $percentage > $max_percentage ) {
						$max_percentage = $percentage;
					}
				}
			}
			if ( $max_percentage > 0 ) {
				echo '-' . round($max_percentage) . '%';
			}

		}


		/**
		 * @return void
		 * autohive_the_woo_product_ratting()
		 * the function render only rating number count
		 */
		public static function the_product_ratting() {
			global $product;
			$rating_count   = $product->get_rating_count();
			$average_rating = $product->get_average_rating();
			if ( $rating_count > 0 ) {
				?>
				<div class="ratting d-flex align-items-center">
					<?php echo wc_get_rating_html( $average_rating, $rating_count ); ?>
				</div>
				<?php
			}

		}

		/**
		 * Undocumented function
		 *
		 * @param [type] $fragments
		 * @return void
		 */
		public static function add_to_cart_count_fragments( $fragments ) {
			$fragments['sup.add_to_cart_count'] = '<sup class="add_to_cart_count">' . WC()->cart->get_cart_contents_count() . '</sup>';
			return $fragments;
		}

		public static function autohive_update_mini_cart() {
			echo wc_get_template('cart/mini-cart.php');
			die();
		}
	}



}

new Autohive_Core_Woo_Helper();