<?php

class Ajax
{

    public function __construct()
    {

        // Auction Filter
        add_action('wp_ajax_filter_listing', [$this, 'autohive_filter_listing']);
        add_action('wp_ajax_nopriv_filter_listing', [$this, 'autohive_filter_listing']);

    }

    public function autohive_car_bodytype( $brand )
    {
        $args = array(
            'post_type' => 'autohive_listing',
            'posts_per_page' => -1,
            'tax_query' => array(
                array(
                    'taxonomy' => 'autohive_listing_brand',
                    'field'    => 'slug',
                    'terms'    => $brand,
                ),
            ),

        );
        $postslist = get_posts($args);
        $bodyType = array();
        foreach ($postslist as $key => $item) {

            $meta = get_post_meta($item->ID, 'car_body_type', true);
            if( !empty( $meta ) ) {
                $bodyType[] = $meta;
            }
        }
        
        return array_unique($bodyType);
    }

    public function autohive_car_model( $brand, $bodytype_, $model )
    {
        $args = array(
            'post_type'     => 'autohive_listing',
            'posts_per_page'=> -1,
            'orderby'       => 'meta_value',
        );

        if( !empty( $brand ) ){
            $args['tax_query'] = [
                ['taxonomy' => 'autohive_listing_brand', 'field'   => 'slug', 'terms' => $brand ]
            ];
        }
        
        if( !empty( $bodytype_ ) ){
            $args['meta_query'] = [
                ['key' => 'car_body_type', 'value'   => $bodytype_ ]
            ];
        }
        if( !empty( $model ) ){
            $args['meta_query'] = [
                ['key' => 'car_model', 'value'   => $model ]
            ];
        }
        


        $postslist = get_posts($args);
        $carModel = array();
        foreach ($postslist as $key => $item) {

            $car_model = get_post_meta( $item->ID, 'car_model', true );
            
            $carModel[$key] = $car_model;
        }
        return array_unique($carModel);
    }
    
    
    public function autohive_car_transmissions( $brand, $body_type, $car_model, $transmissions )
    {
        $args = array(
            'post_type'     => 'autohive_listing',
            'posts_per_page' => -1,
            'orderby'       => 'meta_value',
        );

        if (!empty($brand)) {
            $args['tax_query'] = [
                ['taxonomy' => 'autohive_listing_brand', 'field'   => 'slug', 'terms' => $brand]
            ];
        }

        if (!empty($body_type)) {
            $args['meta_query'] = [
                ['key' => 'car_body_type', 'value'   => $body_type]
            ];
        }
        if (!empty($car_model)) {
            $args['meta_query'] = [
                ['key' => 'car_model', 'value'   => $car_model]
            ];
        }
        if (!empty($transmissions)) {
            $args['meta_query'] = [
                ['key' => 'car_transmissions', 'value'   => $transmissions]
            ];
        }

        $postslist = get_posts($args);
        $carTransmissions = array();
        foreach ($postslist as $key => $item) {

            $car_transmissions = get_post_meta($item->ID, 'car_transmissions', true);

            $carTransmissions[$key] = $car_transmissions;
        }
        return array_unique($carTransmissions);
    }

    /**
     * Auction Filter
     */
    public function autohive_filter_listing() {


        $posttype   = isset($_POST['post_type']) ? sanitize_text_field($_POST['post_type']) : 'post';
        $brand      = isset($_POST['brand']) ? sanitize_text_field($_POST['brand']) : '0';
        $body_type  = isset($_POST['car_body_type']) ? sanitize_text_field($_POST['car_body_type']) : '';
        $car_model  = isset($_POST['car_model']) ? sanitize_text_field($_POST['car_model']) : '';
        $transmissions = isset($_POST['car_transmissions']) ? sanitize_text_field($_POST['car_transmissions']) : '';

        if (!isset( $posttype )) {
            wp_send_json_error(['error' => true, 'message' => esc_html__('Couldn\'t found any data', 'load-more-ajax-lite')]);
        }

        $args['suppress_filters'] = true;
        $args['post_type'] = $posttype;
        
        if ( $brand > 0 ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'autohive_listing_brand',
                    'field'    => 'term_id',
                    'terms'    =>  $brand
                ),
            );
        }

        $query = new \WP_Query($args);

        $postdata = [];

        if( !empty( $brand ) ){
            $postdata['posts'][] = [
                'body_type'     => self::autohive_car_bodytype( $brand )
            ];
        }
        if ( !empty( $body_type ) ) {
            $postdata['posts'][] = [
                'model'     => self::autohive_car_model( $brand, $body_type, $car_model )
            ];
        }
        if ( !empty( $car_model ) ) {
            $postdata['posts'][] = [
                'transmissions' => self::autohive_car_transmissions( $brand, $body_type, $car_model, $transmissions )
            ];
        }
        

        wp_send_json_success($postdata);

    }

    
}

$obj = new Ajax();
