<?php

class Advance_Search_Autoparts
{

    public function __construct()
    {

        // Auction Filter
        add_action('wp_ajax_autoparts_filter', [$this, 'autohive_autoparts_filter']);
        add_action('wp_ajax_nopriv_autoparts_filter', [$this, 'autohive_autoparts_filter']);
    }

    /**
     * Car Build Year Filter
     *
     * @param [type] $brand
     * @param [type] $buildyear
     * @return void
     */
    public function autoparts_build_year($brand)
    {
        $args = array(
            'post_type'     => 'product',
            'posts_per_page' => -1,
            'orderby'       => 'meta_value',
        );

        if (!empty($brand)) {
            $args['tax_query'] = [
                ['taxonomy' => 'product_brand', 'field' => 'slug', 'terms' => $brand]
            ];
        }



        $postslist = get_posts($args);
        $build_year = array();
        foreach ($postslist as $key => $item) {

            $build_year_ = get_post_meta($item->ID, 'buildYear', true);

            $build_year[$key] = $build_year_;
        }
        return array_unique( $build_year );
    }

    /**
     * Car Model Filter
     *
     * @param [type] $brand
     * @param [type] $buildyear
     * @param [type] $model
     * @return void
     */
    public static function autohive_car_model($brand, $buildyear)
    {
        $args = array(
            'post_type'     => 'product',
            'posts_per_page' => -1,
            'orderby'       => 'meta_value',
        );

        if (!empty($brand)) {
            $args['tax_query'] = [
                ['taxonomy' => 'product_brand', 'field'   => 'slug', 'terms' => $brand]
            ];
        }

        if (!empty($buildyear)) {
            $args['meta_query'] = [
                ['key' => 'buildYear', 'value'   => $buildyear]
            ];
        }

        $postslist = get_posts($args);
        $carModel = array();
        foreach ($postslist as $key => $item) {

            $car_model = get_post_meta($item->ID, 'carModel', true);

            $carModel[$key] = $car_model;
        }
        return array_unique( $carModel );
    }

    public static function autohive_car_parts($brand, $buildyear, $carmodel, $partsnumber)
    {

        $args = array(
            'post_type'     => 'product',
            'posts_per_page' => -1,
            'orderby'       => 'meta_value',
        );

        if (!empty($brand)) {
            $args['tax_query'] = [
                ['taxonomy' => 'product_brand', 'field'   => 'slug', 'terms' => $brand]
            ];
        }

        if (!empty($buildyear)) {
            $args['meta_query'] = [
                ['key' => 'buildYear', 'value'   => $buildyear]
            ];
        }

        if (!empty($carmodel)) {
            $args['meta_query'] = [
                ['key' => 'carModel', 'value'   => $carmodel]
            ];
        }


        $postslist = get_posts($args);
        $carParts = array();
        foreach ($postslist as $key => $item) {

            $myquery = esc_attr($partsnumber);
            $a = $myquery;
            $parts_number_meta = get_post_meta( $item->ID, 'partsNumber', true);
            // if (stripos("/{$parts_number_meta}/", $a) !== false) {
            // }
            $carParts[$key] = $parts_number_meta;
        }
        return array_unique( $carParts );
    }




    /**
     * Auction Filter
     */
    public function autohive_autoparts_filter()
    {

        $brand      = isset($_POST['brand']) ? sanitize_text_field($_POST['brand']) : '0';
        $buildYear  = isset($_POST['buildyear']) ? sanitize_text_field($_POST['buildyear']) : '';
        $car_model  = isset($_POST['carmodel']) ? sanitize_text_field($_POST['carmodel']) : '';
        $car_parts  = isset($_POST['keyword']) ? sanitize_text_field($_POST['keyword']) : '';

        if (!isset($brand)) {
            wp_send_json_error(['error' => true, 'message' => esc_html__('Couldn\'t found any data', 'load-more-ajax-lite')]);
        }

        $args['suppress_filters'] = true;
        $args['post_type'] = 'product';

        if ($brand > 0) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'product_brand',
                    'field'    => 'term_id',
                    'terms'    =>  $brand
                ),
            );
        }

        $query = new \WP_Query($args);

        $postdata = [];


        if (!empty($brand)) {
            $postdata['posts'][] = [
                'build_year'    => self::autoparts_build_year($brand)
            ];
        }

        if (!empty($buildYear)) {
            $postdata['posts'][] = [
                'car_model'     => self::autohive_car_model($brand, $buildYear)
            ];
        }

        if (!empty( $car_model )) {
            $postdata['posts'][] = [
                'parts_number'  => self::autohive_car_parts($brand, $buildYear, $car_model, $car_parts)
            ];
        }

        wp_send_json_success($postdata);
    }
}

$obj = new Advance_Search_Autoparts();
