<section class="sr-feedback-section overflow-hidden">
    <div class="swiper sr-feedback-slider overflow-visible mt-40"
        data-perpage="<?php echo esc_attr( $show_items_desktop ) ?>" 
        data-loop="<?php echo $carousel_loop == 'yes' ? 'true' : 'false' ?>" 
        data-space="<?php echo esc_attr( $item_space['size'] ) ?>"
        data-speed="<?php echo esc_attr( $slide_speed ) ?>"
        data-breakpoints='{"1200": {"slidesPerView": <?php echo esc_attr($show_items_desktop) ?>}, "991": {"slidesPerView": <?php echo esc_attr($show_items_tablet) ?>}, "320": {"slidesPerView": <?php echo esc_attr($show_items_mobile) ?>}}' >
        <div class="swiper-wrapper">
            <?php
            if ( is_array($testimonials3) ) {
                foreach ( $testimonials3 as $item ) {
                    ?>
                    <div class="sr-feedback-single bg-white rounded swiper-slide">
                        <?php
                        if ( !empty($item['name']) ) { ?>
                            <div class="sr-feedback-top">
                                <?php echo wp_get_attachment_image($item['author_img']['id'], 'autohive_88x88', '', array( 'class' => 'rounded-circle border-2 client-thumb' )) ?>
                                <h5 class="mb-0 mt-3 __name"><?php echo esc_html($item['name']) ?></h5>
                                <span class="fw-500 __designation"><?php echo esc_html($item['designation']) ?></span>
                            </div>
                            <?php
                        }
                        ?>
                        <div class="sr-feedback-quote d-flex align-items-center mt-4 mb-4">
                            <span class="quote bg-primary-light flex-shrink-0 d-inline-flex align-items-center justify-content-center rounded-circle text-primary"><i class="fa-solid fa-quote-right"></i></span>
                            <span class="hr-line ms-3"></span>
                        </div>
                        <?php
                        if ( !empty($item['contents']) ) { ?>
                            <p class="__content"><?php echo esc_html($item['contents']) ?></p>
                            <?php
                        }
                        if ( !empty($item['author_img']) ) { ?>
                            <ul class="rating-field d-flex">
                                <?php autohive_el_ratting($item, 'rating') ?>
                            </ul>
                            <?php
                        }
                        ?>
                    </div>
                    <?php
                }
            }
            ?>
        </div>
    </div>
</section>