<div class="feedback-slider-area">
    <div class="feedback-slider position-relative">
        <div class="swiper at_feedback_slider"
            data-perpage="<?php echo esc_attr( $show_items_desktop ) ?>" 
            data-loop="<?php echo $carousel_loop == 'yes' ? 'true' : 'false' ?>" 
            data-next=".slide-btn-next" 
            data-prev=".slide-btn-prev"
            data-space="<?php echo esc_attr( $item_space['size'] ) ?>"
            data-speed="<?php echo esc_attr( $slide_speed ) ?>"
            data-breakpoints='{"1200": {"slidesPerView": <?php echo esc_attr($show_items_desktop) ?>}, "991": {"slidesPerView": <?php echo esc_attr($show_items_tablet) ?>}, "320": {"slidesPerView": <?php echo esc_attr($show_items_mobile) ?>}}' >
            <div class="swiper-wrapper">
                <?php 
                if ( is_array($testimonials) ) {
                    foreach ( $testimonials as $item ) {
                        ?>
                        <div class="swiper-slide feedback-single bg-white position-relative rounded">
                            <?php
                            if ( !empty($item['ratting_num']) ) { ?>
                                <div class="rating-box position-absolute rounded-1">
                                    <span class="me-1">
                                        <i class="fa-solid fa-star"></i>
                                    </span>
                                    <?php echo esc_html($item['ratting_num']) ?>
                                </div>
                                <?php
                            }
                            if ( !empty($item['title']) ) { ?>
                                <h4 class="mb-3 __title"><?php echo esc_html($item['title']) ?></h4>
                                <?php
                            }
                            if ( !empty($item['contents']) ) { ?>
                                <p class="mb-4 __contents"><?php echo esc_html($item['contents']) ?></p>
                                <?php
                            }
                            if ( !empty($item['name']) ) { ?>
                                <div class="author-info d-flex align-items-center">
                                    <?php echo wp_get_attachment_image($item['author_img']['id'], 'full', '', array( 'class' => 'rounded-circle flex-shrink-0 border border-2' )) ?>
                                    <div class="author-info-content ms-3">
                                        <h6 class="mb-1 text-secondary __name"><?php echo esc_html($item['name']) ?></h6>
                                        <span class="__designation"><?php echo esc_html($item['designation']) ?></span>
                                    </div>
                                </div>
                                <?php
                            }
                            if ( !empty($settings['quote_image']['id']) ) { ?>
                                <span class="quote-icon position-absolute">
                                    <?php echo wp_get_attachment_image($settings['quote_image']['id'], 'full' ) ?>
                                </span>
                                <?php
                            }
                            ?>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
            <div class="slide-arrow-btn position-absolute slide-btn-next" tabindex="0" role="button" aria-label="Next slide"><i class="fa-solid fa-arrow-right"></i></div>
            <div class="slide-arrow-btn position-absolute slide-btn-prev" tabindex="0" role="button" aria-label="Previous slide"><i class="fa-solid fa-arrow-left"></i></div>
            <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
        </div>
    </div>
</div>