<section class="el-service-section __autohive_sec">
    <div class="row">
        <div class="offset-lg-6 col-lg-6 align-self-end">
            <div class="text-end">
                <button type="button" class="el-service-slider-prev el-service-slider-control"><i class="fas fa-arrow-left"></i></button>
                <button type="button" class="el-service-slider-next el-service-slider-control ms-3"><i class="fas fa-arrow-right"></i></button>
            </div>
        </div>
    </div>
    <div class="mt-5">
        <div class="el-service-slider swiper"
             data-perpage="<?php echo esc_attr( $show_items_desktop ) ?>"
             data-loop="<?php echo $carousel_loop == 'yes' ? 'true' : 'false' ?>"
             data-next=".el-service-slider-next"
             data-prev=".el-service-slider-prev"
             data-space="<?php echo esc_attr( $item_space['size'] ) ?>"
             data-speed="<?php echo esc_attr( $slide_speed ) ?>"
             data-breakpoints='{"1200": {"slidesPerView": <?php echo esc_attr($show_items_desktop) ?>}, "991": {"slidesPerView": <?php echo esc_attr($show_items_tablet) ?>}, "320": {"slidesPerView": <?php echo esc_attr($show_items_mobile) ?>}}'
        >
            <div class="swiper-wrapper">
                <?php
                while ( $service_posts->have_posts() ) : $service_posts->the_post();
                    ?>
                    <div class="el-service-box bg-white rounded overflow-hidden swiper-slide">
                        <figure class="overflow-hidden mb-0">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail( 'full', [ 'class' => 'img-fluid' ] ); ?>
                            </a>
                        </figure>
                        <div class="el-service-box-content">
                            <a href="<?php the_permalink(); ?>">
                                <h4 class="mb-3 __title"><?php echo Autohive_Core_Helper::get_the_title_length($settings, 'title_length') ?></h4>
                            </a>
                            <p class="mb-4 __content"><?php echo Autohive_Core_Helper::get_the_excerpt_length($settings, 'excerpt_length') ?></p>
                            <a href="<?php the_permalink(); ?>" class="el-explore fs-md fw-bold">
                                <?php echo esc_html($settings['read_more_btn']) ?>
                                <span class="ms-2">
                                      <svg width="32" height="9" viewBox="0 0 32 9" fill="none"
                                           xmlns="http://www.w3.org/2000/svg">
                                          <path d="M0 4.99829L26.5 4.9983" stroke="#242430" stroke-width="1.5"/>
                                          <path d="M32 4.99829L26 8.46239L26 1.53419L32 4.99829Z" fill="#242430"/>
                                      </svg>
                                  </span>
                            </a>
                        </div>
                    </div>
                <?php
                endwhile;
                wp_reset_postdata();
                ?>
            </div>
        </div>
    </div>
    <span class="els-circle-gradient position-absolute z--1"></span>
</section>