<section class="sr-service-section __autohive_sec">
    <div class="row g-4">
		<?php
		while ( $service_posts->have_posts() ) : $service_posts->the_post();
			$icon_img = get_post_meta( get_the_ID(), 'service_icon', true );
			?>
            <div class="col-xl-4 col-lg-6 col-sm-10">
                <div class="sr-service-single rounded-top bg-white rounded overflow-hidden">
                    <div class="feature-img overflow-hidden">
						<?php the_post_thumbnail( 'autohive_416x324', array( 'class' => 'img-fluid' ) ); ?>
                    </div>
                    <div class="sr-service-content position-relative pt-5 pb-30 px-4">
						<?php if ( $icon_img != '' ) : ?>
                            <span class="icon-wrapper d-inline-flex align-items-center justify-content-center bg-white position-absolute">
                            <?php echo wp_get_attachment_image( $icon_img['id'], 'full', '', array( 'class' => 'img-fluid' ) ); ?>
                        </span>
						<?php endif ?>
                        <a href="<?php the_permalink(); ?>" class="title" title="<?php the_title_attribute() ?>">
                            <h3 class="h4 mb-3 __title"><?php echo Autohive_Core_Helper::get_the_title_length( $settings, 'title_length' ) ?></h3>
                        </a>
                        <p class="__content"><?php echo Autohive_Core_Helper::get_the_excerpt_length( $settings, 'excerpt_length' ) ?></p>
                    </div>
                    <a href="<?php the_permalink(); ?>"
                       class="btn btn-secondary w-100 text-start position-relative z-1">
                        <span><?php echo esc_html($settings['read_more_btn']) ?><i
                                    class="fa-solid fa-arrow-right"></i></span>
                        <img src="<?php echo AUTOHIVE_CORE_DIR_EL_IMG . '/shapes/tire-shape.png' ?>"
                             class="tire-shape-black position-absolute end-0 top-0 z--1" alt="tire shape">
                        <img src="<?php echo AUTOHIVE_CORE_DIR_EL_IMG . '/shapes/tire-shape-white.png' ?>"
                             class="tire-shape-white position-absolute end-0 top-0 z--1" alt="tire shape">
                    </a>
                </div>
            </div>
		<?php
		endwhile;
		wp_reset_postdata();
		?>
    </div>
</section>