<section class="woocommerce">
    <div class="row">
        <div class="offset-xl-6 col-xl-6 align-self-end">
            <div class="bs-filter-btn-group d-flex align-items-center justify-content-center justify-content-xl-end flex-wrap">
                <?php
                $i = 0;
                if ( $product_tab != '' ) {
                    foreach ( $product_tab as $tab_item ) {
                        $active = $i == 0 ? ' active' : '';
                        $tab_id = !empty($tab_item['select_query']) ? $tab_item['select_query'] : '';
                        ?>
                        <button class="bs-filter-btn h4-filter-btn<?php echo esc_attr($active) ?>" data-filter=".<?php echo esc_attr($tab_id) ?>">
                            <?php echo esc_html($tab_item['tab_title']) ?>
                        </button>
                        <?php
                        ++$i;
                    }
                }
                ?>
            </div>
        </div>
    </div>
    <div class="best-selling-products-list mt-5">
        <div class="row g-4 filter_grid_3">
            <?php
            $i = 0;
            if ( $product_tab != '' ) {
                foreach ( $product_tab as $tab_item ) {
                    $tab_id = !empty($tab_item['select_query']) ? $tab_item['select_query'] : '';
                    $args = [
                        'post_type' => 'product',
                        'post_status' => 'publish',
                    ];

                    if ( !empty($tab_item['show_count']) ) {
                        $args['posts_per_page'] = $tab_item['show_count'];
                    }

                    if ( !empty($tab_item['exclude']) ) {
                        $args['post__not_in'] = $tab_item['exclude'];
                    }

                    // Get Best Selling Product
                    if ( $tab_item['select_query'] == 'best_seller' ) {
                        $args['meta_key'] = 'total_sales';
                        $args['order'] = 'DESC';
                        $args['orderby'] = 'meta_value_num';
                    }

                    // Get Most Popular Product
                    if ( $tab_item['select_query'] == 'popular' ) {
                        $args['meta_key'] = 'post_views_count';
                        $args['order'] = 'DESC';
                        $args['orderby'] = 'meta_value_num';
                    }

                    // Get Featured Product
                    if ( $tab_item['select_query'] == 'featured' ) {
                        $args['post__in'] = wc_get_featured_product_ids();
                    }

                    $tab_query = new \WP_Query( $args );

                    while ($tab_query->have_posts()) : $tab_query->the_post();
                        global $product;
                        ?>
                        <div class="col-xl-<?php echo esc_attr($settings['column']) ?> col-lg-4 col-md-6 col-sm-10 <?php echo esc_attr($tab_id) ?>">
                            <div class="h4-ft-product-card bg-white rounded">
                                <div class="product-card-top position-relative overflow-hidden">
                                    <?php
                                    if ( !empty($product->get_sale_price()) ) { ?>
                                        <span class="discount-badge position-absolute fw-500 z-1"><?php Autohive_Core_Woo_Helper::the_display_sale_percentage(); ?></span>
                                        <?php
                                    }
                                    if ( class_exists('YITH_WCWL') ) {
                                        echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                    }
                                    the_post_thumbnail('autohive_306x245', array( 'class' => 'img-fluid feature-img' ));
                                    ?>
                                    <div class="at_product_action position-absolute start-50 translate-middle-x z-1">
                                        <?php

                                        woocommerce_template_loop_add_to_cart();

                                        if ( shortcode_exists('yith_quick_view') ) {
                                            echo do_shortcode('[yith_quick_view]');
                                        }

                                        if ( class_exists('TT_Compare_Products') && shortcode_exists('tt_compare_button') ) {
	                                        echo do_shortcode('[tt_compare_button product_id="'.get_the_ID().'"]');
                                        }
                                        ?>
                                    </div>
                                </div>
                                <div class="product-card-bottom mt-4">
                                    <div class="product-rating mb-1">
                                        <?php Autohive_Core_Woo_Helper::the_product_ratting(); ?>
                                    </div>
                                    <a href="<?php the_permalink(); ?>" class="product-title">
                                        <?php echo Autohive_Core_Helper::get_the_title_length($settings,'title_length') ?>
                                    </a>
                                    <div class="product-pricing mt-2">
                                        <?php woocommerce_template_loop_price() ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                    endwhile;
                    wp_reset_postdata();
                }
            }
            ?>

        </div>
    </div>
</section>

<script>
    ;(function ($) {
        'use strict'

        $(document).ready(function () {
            var activeBtn = $('.bs-filter-btn.active').attr('data-filter');
            var $filter_grid_3 = $('.filter_grid_3').isotope({
                filter: activeBtn
            });

            $('.bs-filter-btn-group').on('click', 'button', function () {
                var filterValue = $(this).attr('data-filter');
                $filter_grid_3.isotope({
                    filter: filterValue
                });
                $(this).parent(".bs-filter-btn-group").find("button.active").removeClass("active");
                $(this).addClass("active");
            }); //masonry grid
        })

    })(jQuery)
</script>