<section class="h4-feature-product woocommerce">
    <div class="row">
        <div class="offset-xl-6 col-xl-6 align-self-end">
            <div class="h4-filter-btn-group d-flex align-items-center justify-content-center justify-content-xl-end mt-4 mt-xl-0 flex-wrap">
				<?php
                if ( $settings['all_label'] != '' ) {
                    ?>
                    <button class="h4-filter-btn active" data-filter="*"><?php echo esc_html($settings['all_label']) ?></button>
                    <?php
                }
				if ( $settings['cats'] != '' ) {
					foreach ( $settings['cats'] as $cat ) {
                        $cat_name = str_replace('-', ' ', $cat);
						?>
                        <button class="h4-filter-btn" data-filter=".<?php echo esc_attr($cat) ?>">
							<?php echo esc_html(ucwords($cat_name)) ?>
                        </button>
						<?php
					}
				}
				?>
            </div>
        </div>
    </div>
    <div class="mt-5">
        <div class="row g-4 filter_grid_2">
			<?php
			while ($product_query->have_posts()) : $product_query->the_post();
				global $product;
				$p_cat = get_the_terms(get_the_ID(), 'product_cat');
				$p_cat_slug = '';
                if( !empty( $p_cat ) && is_array( $p_cat ) ){
                    foreach ( $p_cat as $cat ) {
                        $p_cat_slug .= $cat->slug .' ';
                    }
                }
				?>
                <div class="col-xl-<?php echo esc_attr($settings['column']) ?> col-lg-4 col-md-6 col-sm-10 <?php echo esc_attr($p_cat_slug) ?>">
                    <div class="h4-ft-product-card bg-white rounded">

                        <div class="product-card-top position-relative overflow-hidden">
							<?php
							if ( !empty($product->get_sale_price()) ) { ?>
                                <span class="discount-badge position-absolute fw-500 z-1"><?php Autohive_Core_Woo_Helper::the_display_sale_percentage(); ?></span>
								<?php
							}
							if ( class_exists('YITH_WCWL') ) {
								echo do_shortcode('[yith_wcwl_add_to_wishlist]');
							}
							the_post_thumbnail('autohive_306x245', array( 'class' => 'img-fluid feature-img' ));
							?>
                            <div class="at_product_action position-absolute start-50 translate-middle-x z-1">
								<?php

								woocommerce_template_loop_add_to_cart();

								if ( shortcode_exists('yith_quick_view') ) {
									echo do_shortcode('[yith_quick_view]');
								}

								if ( class_exists('TT_Compare_Products') && shortcode_exists('tt_compare_button') ) {
									echo do_shortcode('[tt_compare_button product_id="'.get_the_ID().'"]');
								}
								?>
                            </div>
                        </div>

                        <div class="product-card-bottom mt-4">
                            <div class="product-rating mb-1">
								<?php  Autohive_Core_Woo_Helper::the_product_ratting(); ?>
                            </div>
                            <a href="<?php the_permalink(); ?>" class="product-title" title="<?php the_title_attribute() ?>">
	                            <?php echo Autohive_Core_Helper::get_the_title_length($settings,'title_length') ?>
                            </a>
                            <div class="product-pricing mt-2">
								<?php woocommerce_template_loop_price() ?>
                            </div>
                        </div>
                    </div>
                </div>
			<?php
			endwhile;
			wp_reset_postdata();
			?>
        </div>
    </div>
</section>


<script>
    ;(function ($) {
        'use strict'

        $(document).ready(function () {
            var $filter_grid_2 = $('.filter_grid_2').isotope({});
            $('.h4-filter-btn-group').on('click', 'button', function () {
                var filterValue = $(this).attr('data-filter');
                $filter_grid_2.isotope({
                    filter: filterValue
                });
                $(this).parent(".h4-filter-btn-group").find("button.active").removeClass("active");
                $(this).addClass("active");
            });
        })

    })(jQuery)
</script>