<?php
$meta = get_post_meta(get_the_ID(), 'tt_page_options', true);
$is_cta_enabled = isset($meta['is_cta_enabled']) ? $meta['is_cta_enabled'] : '';
$mobile_logo    = autohive_opt('mobile_logo');
$ml_ratina      = autohive_opt('mobile_retina_logo');
$sticky         = autohive_opt('sticky_logo');
$retina_sticky  = autohive_opt('retina_logo_sticky');
$is_contact_info = autohive_opt('is_contact_info', false);
$canvas_logo    = autohive_opt('canvas_logo');
$canvas_title    = autohive_opt('canvas_title');
$canvas_contents    = autohive_opt('canvas_contents');
$canvas_btn_label    = autohive_opt('canvas_btn_label');
$canvas_btn_url    = autohive_opt('canvas_btn_url');
$contact_title    = autohive_opt('contact_title');
$contact_address = autohive_opt('contact_address');
$contact_number = autohive_opt('contact_phone');
$contact_email    = autohive_opt('contact_email');
$social_links     = autohive_opt('social_links');
?>
<header class="auto-parts-header">
    <div class="autoparts-header-middle p-0">
        <div class="row">
            <div class="offset-lg-9 col-lg-3 align-self-end">
                <div class="autoparts-header-right d-flex align-items-center justify-content-end justify-content-xl-between">
                    <button class="mobile-menu-toggle header-toggle-btn bg-transparent d-lg-none">
                        <span class="bg-white"></span>
                        <span class="bg-white"></span>
                        <span class="bg-white"></span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="autoparts-header-navigation d-none d-lg-flex align-items-center justify-content-between">
        <div class="nav-left d-flex align-items-center">
            <div class="category-dropdown position-relative">
                <button class="category-toggle"><span class="me-2"><i class="flaticon-menu-bar"></i></span><?php esc_html_e('Product Category', 'autohive-core'); ?></button>
                <?php echo $vertical_menu_html; ?>
            </div>
            <nav class="autoparts-header-menu at_nav_menu ms-4 d-none d-lg-block">
                <?php echo $main_menu_html; ?>
            </nav>
        </div>
        <div class="atp_header_right d-flex align-items-center justify-content-end">
            <form class="apt_header_search dropdown" method="get">
                <button class="apt_search_toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="flaticon-search-2"></i></button>
                <div class="dropdown-menu dropdown-menu-end p-0 border border-1 rounded overflow-hidden" style="">
                    <div class="d-flex align-items-center">
                        <input type="text" name="s" value="<?php echo get_search_query() ?>" placeholder="<?php esc_attr_e('Search...', 'autohive-core'); ?>">
                        <button type="submit" class="bg-transparent text-secondary fw-bold border-start"><?php esc_html_e('Go', 'autohive-core'); ?></button>
                    </div>
                </div>
            </form>
            <?php

            if (class_exists('YITH_WCWL') && function_exists('yith_wcwl_count_all_products')) {
            ?>
                <div class="apt_wish_btn">
                    <a href="<?php echo esc_url(YITH_WCWL()->get_wishlist_url()); ?>" class="apt_wish_btn">
                        <i class="flaticon-heart"></i>
                        <sup><?php echo esc_html(yith_wcwl_count_all_products()); ?></sup>
                    </a>
                </div>
            <?php
            }
            if (class_exists('TT_Compare_Products') && shortcode_exists('tt_compare_product_counter_nav')) {
                echo do_shortcode('[tt_compare_product_counter_nav url="' . (esc_url($settings['compare_page_link']['url'])) . '" icon_class="flaticon-arrow"]');
            }
            if (class_exists('WooCommerce') && !is_null(WC()->cart)) { ?>
                <div class="apt_header_cart position-relative">
                    <button class="cart_btn bg-secondary text-white">
                        <i class="flaticon-trolley-cart"></i>
                        <sup class="add_to_cart_count"><?php echo WC()->cart->get_cart_contents_count(); ?></sup>
                    </button>
                    <div class="apt_cart_box">
                        <?php woocommerce_mini_cart(); ?>
                    </div>
                </div>
            <?php
            }
            ?>
        </div>
    </div>
</header>

<div class="mobile-menu position-fixed bg-white deep-shadow">
    <button class="close-menu position-absolute"><i class="fa-solid fa-xmark"></i></button>
    <?php
    if (!empty($mobile_logo['url'])) {
        echo '<a href="' . esc_url(home_url('/')) . '" class="logo-wrapper bg-secondary d-block mt-4 p-3 rounded-1 text-center"><img src="' . esc_url($mobile_logo['url']) . '" alt="' . esc_attr(get_bloginfo('name')) . '" class="img-fluid"></a>';
    } elseif (!empty($sticky['url'])) {
        echo '<a href="' . esc_url(home_url('/')) . '" class="logo-wrapper bg-secondary d-block mt-4 p-3 rounded-1 text-center"><img src="' . esc_url($sticky['url']) . '" alt="' . esc_attr(get_bloginfo('name')) . '" class="img-fluid"></a>';
    } else {
        echo '<a href="' . esc_url(home_url('/')) . '" class="logo-wrapper bg-secondary d-block mt-4 p-3 rounded-1 text-center"><h1>' . esc_html(get_bloginfo('name')) . '</h1></a>';
    }
    ?>
    <nav class="mobile-menu-wrapper mt-40">
        <?php echo $main_menu_html ?>
    </nav>
    <div class="contact-info mt-60">
        <?php
        if ($is_contact_info == '1') {
            if (!empty($contact_title)) {
                echo '<h4 class="mb-20">' . esc_html($contact_title) . '</h4>';
            }
            if (!empty($contact_address)) {
                echo '<p>' . esc_html($contact_address) . '</p>';
            }
            if (!empty($contact_number)) {
                echo '<p>' . esc_html($contact_number) . '</p>';
            }
            if (!empty($contact_email)) {
                echo '<p>' . esc_html($contact_email) . '</p>';
            }
            // Social links
            if (is_array($social_links)) {
                echo '<div class="social-contact">';
                foreach ($social_links as $item) {
                    echo '<a href="' . esc_url($item['url']) . '"><i class="' . esc_attr($item['icon']) . '"></i></a>';
                }
                echo '</div>';
            }
        ?>
        <?php
        }
        ?>
    </div>
</div>