<?php
while ($listing_posts->have_posts()) {
    $listing_posts->the_post();
    $regularPrice   = get_post_meta(get_the_ID(), 'regular_price', true);
    $carFuelType    = get_post_meta(get_the_ID(), 'fuel_type', true);
    $transmissions  = get_post_meta(get_the_ID(), 'car_transmissions', true);
    $carEngineSize  = get_post_meta(get_the_ID(), 'car_engine_size', true);
    $dealer         = get_post_meta(get_the_ID(), 'select_dealer', true); ?>

    <div class="col-12">
        <div class="listing_card_item bg-white rounded p-4 d-lg-flex align-items-center position-relative">
            <div class="thumb-wrapper overflow-hidden rounded flex-shrink-0">
                <a href="<?php the_permalink() ?>">
                    <?php the_post_thumbnail('listing_315x242', array('class' => 'img-fluid')) ?>
                </a>
            </div>
            <div class="listing_card_content ms-lg-4 mt-4 mt-lg-0">
                <?php
                if (!empty($regularPrice)) {
                    echo '<span class="small-btn-meta">' . esc_html($regularPrice) . '</span>';
                }
                ?>
                <a href="<?php the_permalink() ?>">
                    <h5 class="mb-1"><?php echo Autohive_Core_Helper::get_the_title_length($settings, 'title_length') ?></h5>
                </a>
                <?php
                if (!empty($dealer)) {
                    $dealer_details = get_post($dealer);
                    echo '<span class="meta-text"><strong class="fw-semibold">Listed by:</strong> <a href="' . get_the_permalink($dealer_details->ID) . '">' . esc_html($dealer_details->post_title) . '</a></span>';
                }
                ?>
                <p class="mt-3 mb-4 pera-text-2">
                    <?php echo Autohive_Core_Helper::get_the_excerpt_length($settings, 'excerpt_length') ?>
                </p>
                <div class="card-feature-box d-flex flex-wrap align-items-center">
                    <?php
                    if (!empty($carEngineSize)) {
                        echo '<div class="icon-box d-flex align-items-center border"><span class="me-2"><i class="flaticon-speedometer"></i></span>' . esc_html($carEngineSize) . '</div>';
                    }
                    if (!empty($transmissions)) {
                        echo '<div class="icon-box d-flex align-items-center border"><span class="me-2"><i class="flaticon-steering-wheel"></i></span>' . esc_html($transmissions) . '</div>';
                    }
                    if (!empty($carFuelType)) {
                        echo '<div class="icon-box d-flex align-items-center border"><span class="me-2"><i class="flaticon-petrol"></i></span>' . esc_html($carFuelType) . '</div>';
                    }
                    ?>
                    
                </div>
            </div>
        </div>
    </div>

<?php
}
