<section class="inventory-slider" data-widget_type="<?php echo $this->get_name() .'_'. $layout ?>">
    <div class="inventroy-slider swiper" 
        data-perpage="<?php echo esc_attr($show_items_desktop) ?>" 
        data-loop="true" 
        data-prev=".slider-btn-prev" 
        data-next=".slider-btn-next" 
        data-space="<?php echo esc_attr($item_space) ?>"
        data-speed="<?php echo esc_attr($item_speed) ?>"
        data-breakpoints='{"1200": {"slidesPerView": <?php echo esc_attr($show_items_desktop) ?>}, "991": {"slidesPerView": <?php echo esc_attr($show_items_tablet) ?>}, "320": {"slidesPerView": <?php echo esc_attr($show_items_mobile) ?>}}'
    >
        <div class="swiper-wrapper">
            <?php
            if ($listing_post->have_posts()) {
                while ($listing_post->have_posts()) {
                    $listing_post->the_post();
                    $regularPrice   = get_post_meta(get_the_ID(), 'regular_price', true);
                    $buildYear      = get_post_meta(get_the_ID(), 'build_year', true);
                    $carFuelType    = get_post_meta(get_the_ID(), 'fuel_type', true);
                    $transmissions  = get_post_meta(get_the_ID(), 'car_transmissions', true);
                    $carEngineSize  = get_post_meta(get_the_ID(), 'car_engine_size', true);
                    $dealer         = get_post_meta(get_the_ID(), 'select_dealer', true); ?>
                    
                    <div class="filter-card-item position-relative overflow-hidden rounded bg-white swiper-slide">
                        <?php
                        echo autohive_like_it_button_html(get_the_ID(), 'icon-btn wish-btn position-absolute', true);
                        if (!empty($buildYear)) {
                            echo '<span class="date position-absolute">' . esc_html($buildYear) . '</span>';
                        }
                        ?>
                        <div class="feature-thumb position-relative overflow-hidden">
                            <a href="<?php the_permalink() ?>">
                                <?php the_post_thumbnail('listing_315x242', array('class' => 'img-fluid')) ?>
                            </a>
                        </div>
                        <div class="filter-card-content">
                            <div class="price-btn text-end position-relative">
                                <?php
                                if (!empty($regularPrice)) {
                                    echo '<span class="small-btn-meta">' . esc_html($regularPrice) . '</span>';
                                }
                                ?>
                            </div>
                            <a href="<?php the_permalink() ?>" class="mt-4 d-block">
                                <h5><?php the_title() ?></h5>
                            </a>
                            <?php
                            if (!empty($dealer)) {
                                $dealer_details = get_post($dealer);
                                echo '<span class="meta-content"><strong>Listed by:</strong> <a href="' . get_the_permalink($dealer_details->ID) . '">' . esc_html($dealer_details->post_title) . '</a></span>';
                            }
                            ?>

                            <hr class="spacer mt-3 mb-3">
                            <div class="card-feature-box d-flex align-items-center mb-4">
                                <?php
                                if (!empty($carEngineSize)) {
                                    echo '<div class="icon-box d-flex align-items-center"><span class="me-2"><i class="flaticon-speedometer"></i></span>' . esc_html($carEngineSize) . '</div>';
                                }
                                if (!empty($transmissions)) {
                                    echo '<div class="icon-box d-flex align-items-center"><span class="me-2"><i class="flaticon-steering-wheel"></i></span>' . esc_html($transmissions) . '</div>';
                                }
                                if (!empty($carFuelType)) {
                                    echo '<div class="icon-box d-flex align-items-center"><span class="me-2"><i class="flaticon-petrol"></i></span>' . esc_html($carFuelType) . '</div>';
                                }
                                ?>
                            </div>
                            <a href="<?php the_permalink() ?>" class="btn outline-btn btn-sm d-block"><?php esc_html_e('View Details', 'autohive-core'); ?></a>
                        </div>
                    </div>
                    <?php
                }
            }
            ?>
        </div>
    </div>
    <div class="slider-btn-prev swiper-btn"><i class="fa-solid fa-arrow-left"></i></div>
    <div class="slider-btn-next swiper-btn"><i class="fa-solid fa-arrow-right"></i></div>
</section>