<?php
$car_brand      = !empty($_GET['brand']) ? sanitize_text_field($_GET['brand']) : '';
$bodytype       = !empty($_GET['car_body_type']) ? sanitize_text_field($_GET['car_body_type']) : '';
$car_model      = !empty($_GET['car_model']) ? sanitize_text_field($_GET['car_model']) : '';
$car_transmissions = !empty($_GET['car_transmissions']) ? sanitize_text_field($_GET['car_transmissions']) : '';
$buildYear      = !empty($_GET['build_year']) ? sanitize_text_field($_GET['build_year']) : '';
$order_by       = !empty($_GET['order_by']) ? sanitize_text_field($_GET['order_by']) : '';
$inventory_default = !empty( $inventory ) ? sanitize_text_field($inventory) : 'grid';
$listing_view   = isset($_GET['view']) ? $_GET['view'] : $inventory_default;
$orderby_arr[]  = '';
    

$paged      = (get_query_var('paged')) ? get_query_var('paged') : 1;
$args = [
    'post_type'     => 'autohive_listing',
    'post_status'   => 'publish',
    'posts_per_page' => !empty($show_count) ? $show_count: 6,
    'orderby'       => 'meta_value',
    'order'         => 'DESC',
    'paged'         => $paged
];

if (!empty($cats || $car_brand)) {
    $category = !empty($cats) ? ['taxonomy' => 'autohive_listing_cat', 'field' => 'slug', 'terms' => $cats] : '';
    $carBrand = !empty($car_brand) ? ['taxonomy' => 'autohive_listing_brand', 'field' => 'slug', 'terms' => $car_brand] : '';
    $args['tax_query'] = [
        $category,
        $carBrand
    ];
}

if (!empty($bodytype || $car_model || $car_transmissions || $buildYear || $order_by)) {

    $bodytype_arr   = !empty($bodytype) ? ['key' => 'car_body_type', 'value'   => $bodytype ] : '';
    $carModel_arr   = !empty($car_model) ? ['key' => 'car_model', 'value'   => $car_model] : '';
    $transmissions  = !empty($car_transmissions) ? ['key' => 'car_transmissions', 'value'   => $car_transmissions ] : '';
    $build_year_arr = !empty($buildYear) ? ['key' => 'build_year', 'value'   => $buildYear ] : '';

    if ($order_by == 'popular') {
        $orderby_arr  = ['key' => 'autohive_post_views_count'];
    } elseif ($order_by == 'rated') {
        $orderby_arr  = ['key' => 'comment_count'];
    }

    $args['meta_query'] = array(
        $bodytype_arr,
        $carModel_arr,
        $transmissions,
        $build_year_arr,
        $orderby_arr
    );
}

$listing_posts = new \WP_Query($args);

?>
<div class="iv_listing_top d-flex flex-wrap align-items-center bg-white justify-content-center justify-content-sm-between rounded mb-4">
    <?php
    if ($listing_posts->have_posts()) {
        echo '<p class="mb-0 fw-500 d-inline-block">Showing ' . absint($paged) . ' - ' .  esc_html($listing_posts->max_num_pages) . ' of ' . absint($listing_posts->found_posts) . ' Results</p>';
    } else {
        echo '<p class="mb-0 fw-500 d-inline-block">No post found</p>';
    }
    ?>

    <form class="iv_listing_filter_menu autohive_listing_filter d-flex flex-wrap align-items-center justify-content-center" method="get">
        <p class="mb-0 flex-shrink-0 fw-semibold">Sort by:</p>
        <select class="form-select fw-500 order_by" name="order_by">
            <option value="new" <?php echo esc_attr($order_by == 'new' ? 'selected' : '') ?>>Newest First</option>
            <option value="popular" <?php echo esc_attr($order_by == 'popular' ? 'selected' : '') ?>>Most Popular</option>
            <option value="rated" <?php echo esc_attr($order_by == 'rated' ? 'selected' : '') ?>>Most Rated</option>
        </select>
        <a href="?view=grid" class="grid_btn <?php echo esc_attr($listing_view == 'grid' ? 'active' : '') ?>"><i class="flaticon-menu-1"></i></a>
        <a href="?view=list" class="grid_btn <?php echo esc_attr($listing_view == 'list' ? 'active' : '') ?>"><i class="flaticon-list-interface-symbol"></i></a>
    </form>
</div>
<div class="row g-4">

    <?php
    if ( $listing_posts->have_posts() ) {
        require __DIR__ . '/layout-' . $listing_view . '.php';
        ?>
        <div class="template-pagination mt-5 pg-style-2">
            <?php
            $big = 999999999; // need an unlikely integer
            echo paginate_links(array(
                'base'      => str_replace($big, '%#%', get_pagenum_link($big)),
                'format'    => '?paged=%#%',
                'current'   => max(1, get_query_var('paged')),
                'total'     => $listing_posts->max_num_pages,
                'type'      => 'list',
                'prev_text' => __('<i class="fa-solid fa-angles-left"></i>'),
                'next_text' => __('<i class="fa-solid fa-angles-right"></i>'),
            ));
            ?>
        </div>
        <?php
    }
    wp_reset_postdata();
    ?>
</div>