<section class="latest-collection">
    <div class="row align-items-center justify-content-between">
        <div class="offset-lg-6 col-lg-6 align-self-end">
            <div class="collection-filter-controls d-flex align-items-center justify-content-center justify-content-lg-end flex-wrap">
				<?php
				$i = 1;
				if ( $listing_tab != '' ) {
					foreach ( $listing_tab as $tab_item ) {
						$active = $i == 1 ? ' active' : '';
						$tab_id = !empty($tab_item['select_query']) ? $tab_item['select_query'] : 'new_arrival';
						?>
                        <button class="at-filter-btn<?php echo esc_attr($active) ?>" data-filter=".<?php echo esc_attr($tab_id) ?>">
							<?php echo esc_html($tab_item['tab_title']) ?>
                        </button>
						<?php
						++$i;
					}
				}
				?>
            </div>
        </div>

    </div>

    <div class="filter-items-wrapper mt-5">
        <div class="row g-4 filter-grid">
			<?php
			$i = 0;
			if ( $listing_tab != '' ) {
				foreach ( $listing_tab as $tab_item ) {
					$active = $i == 0 ? ' active' : '';
					$tab_id = ! empty( $tab_item['select_query'] ) ? $tab_item['select_query'] : 'new_arrival';

					$args = [
						'post_type' => 'autohive_listing',
						'post_status' => 'publish',
					];

					if ( !empty($tab_item['show_count']) ) {
						$args['posts_per_page'] = $tab_item['show_count'];
					}

					if ( !empty($tab_item['exclude']) ) {
						$args['post__not_in'] = $tab_item['exclude'];
					}

                    if ( $tab_item['select_query'] == 'new_arrival' ) {
	                    $args['order'] = 'DESC';
	                    $args['orderby'] = 'post_date';
                    }

					//$recent_posts = wp_get_recent_posts( $args );

					// Get Most Popular Product
					if ( $tab_item['select_query'] == 'popular' ) {
						$args['meta_key'] = 'post_views_count';
						$args['order'] = 'DESC';
						$args['orderby'] = 'meta_value_num';
					}

					// Get Featured Product
					if ( $tab_item['select_query'] == 'featured' ) {
						$args['meta_query'] = [
							[
								'key' => 'featured',
								'value' => '1',
							]
						];
					}

					$listing_tab_query = new \WP_Query( $args );

					while ($listing_tab_query->have_posts()) : $listing_tab_query->the_post();
						$regular_price      = get_post_meta(get_the_ID(), 'regular_price', true);
						$car_engine_size      = get_post_meta(get_the_ID(), 'car_engine_size', true);
						$car_transmissions      = get_post_meta(get_the_ID(), 'car_transmissions', true);
						$car_type_of_drive      = get_post_meta(get_the_ID(), 'fuel_type', true);
						$build_year      = get_post_meta(get_the_ID(), 'build_year', true);
						$dealer      = get_post_meta(get_the_ID(), 'select_dealer', true);
						?>
                        <div class="col-xxl-3 col-lg-4 col-md-6 col-sm-12 <?php echo esc_attr($tab_id) ?>">
                            <div class="filter-card-item position-relative overflow-hidden rounded bg-white">
								<?php
								echo autohive_like_it_button_html(get_the_ID(), 'icon-btn wish-btn position-absolute', true);
								if ($build_year) { ?>
                                    <span class="date position-absolute"><?php echo esc_html($build_year) ?></span>
									<?php
								}
								if (has_post_thumbnail()) { ?>
                                    <div class="feature-thumb position-relative overflow-hidden">
                                        <a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail('autohive_740x565', array('class' => 'img-fluid')); ?>
                                        </a>
                                    </div>
									<?php
								}
								?>
                                <div class="filter-card-content">
                                    <div class="price-btn text-end position-relative">
                                        <span class="small-btn-meta"><?php echo esc_html($regular_price) ?></span>
                                    </div>
                                    <a href="<?php the_permalink(); ?>" class="mt-4 d-block">
										<?php the_title('<h5>', '</h5>') ?>
                                    </a>
									<?php
									if (!empty($dealer)) {
										$dealer_details = get_post($dealer);
										echo '<span class="meta-content"><strong>Listed by:</strong> <a href="' . get_the_permalink($dealer_details->ID) . '">' . esc_html($dealer_details->post_title) . '</a></span>';
									}
									?>
                                    <hr class="spacer mt-3 mb-3">
                                    <div class="card-feature-box d-flex align-items-center mb-4">
										<?php
										if ($car_engine_size) { ?>
                                            <div class="icon-box d-flex align-items-center">
                                                <span class="me-2"><i class="flaticon-speedometer"></i></span>
												<?php echo esc_html($car_engine_size) ?>
                                            </div>
											<?php
										}
										if ($car_transmissions) { ?>
                                            <div class="icon-box d-flex align-items-center">
                                                <span class="me-2"><i class="flaticon-steering-wheel"></i></span>
												<?php echo esc_html($car_transmissions) ?>
                                            </div>
											<?php
										}
										if ($car_type_of_drive) { ?>
                                            <div class="icon-box d-flex align-items-center">
                                                <span class="me-2"><i class="flaticon-petrol"></i></span>
												<?php echo esc_html($car_type_of_drive) ?>
                                            </div>
											<?php
										}
										?>
                                    </div>
                                    <a href="<?php the_permalink(); ?>" class="btn outline-btn btn-sm d-block">
                                        View Details
                                    </a>
                                </div>
                            </div>
                        </div>
					    <?php
					endwhile;
					wp_reset_postdata();
					++$i;
				}
			}
			?>
        </div>
    </div>
</section>


<script>

    ;(function ($) {
        'use strict'

        $(document).ready(function () {
			var activeBtn = $('.at-filter-btn.active').attr('data-filter');
            var $grid = $('.filter-grid').isotope({
				filter: activeBtn
			});
            $('.collection-filter-controls').on('click', 'button', function () {
                var filterValue = $(this).attr('data-filter');
                $grid.isotope({
                    filter: filterValue
                });
            }); //active btn switch

            $(".collection-filter-controls button").each(function () {
                $(this).on("click", function () {
                    $(this).parent().find("button.active").removeClass("active");
                    $(this).addClass("active");
                });
            }); // filter grid 2

        })


    })(jQuery)

</script>