<?php
$args = array(
    'post_type' => 'autohive_rent',
    'post_status' => 'publish',
);
if (!empty($show_count)) {
    $args['posts_per_page'] = $show_count;
}

if (!empty($exclude)) {
    $args['post__not_in'] = $exclude;
}

if (!empty($order)) {
    $args['order'] = $order;
}

if (!empty($orderby)) {
    $args['orderby'] = $orderby;
}

if (!empty($cats)) {
    $args['tax_query'] = [
        [
            'taxonomy' => 'autohive_rent_cat',
            'field' => 'slug',
            'terms' => $cats
        ]
    ];
}
$rent_posts = get_posts($args); ?>

<section class="car-slider  elementor-element" data-element_type="widget" data-widget_type="autohive_listing_rent.slider">
    <div class="car-double-slider position-relative position-relative">
        <div class="car-thumb-slider-wrapper">
            <div class="car-thumb-slider">
                <div class="swiper-wrapper">
                    <?php
                    if (is_array($rent_posts) && count($rent_posts) > 0) {
                        foreach ($rent_posts as $item) { ?>
                            <div class="swiper-slide car-thumb-single">
                                <?php echo get_the_post_thumbnail($item->ID, 'autohive_rent_115x70') ?>
                            </div>
                    <?php
                        }
                    }
                    ?>

                </div>
                <div class="slider-button-next slider-btn"><i class="fa-solid fa-arrow-right"></i></div>
                <div class="slider-button-prev slider-btn"><i class="fa-solid fa-arrow-left"></i></div>
            </div>
        </div>
        <div class="car-slider overflow-hidden" data-next=".slider-button-next" data-prve=".slider-button-prev">
            <div class="swiper-wrapper">
                <?php
                if (is_array($rent_posts) && count($rent_posts) > 0) {
                    foreach ($rent_posts as $item) {
                        $dailyRent   = get_post_meta($item->ID, 'daily_rent', true);
                        $monthlyRent = get_post_meta($item->ID, 'monthly_rent', true);
                        $passengers  = get_post_meta($item->ID, 'passengers', true);
                        $suitcase    = get_post_meta($item->ID, 'suitcase', true);
                        $doors       = get_post_meta($item->ID, 'car_doors', true); ?>
                        <div class="car-slider-single position-relative overflow-hidden swiper-slide">
                            <div class="car-slider-item-left bg-white p-4">
                                <?php echo get_the_post_thumbnail($item->ID, 'autohive_rent_675x540') ?>
                            </div>
                            <div class="car-slider-item-right bg-white rounded">
                                <span class="btn-meta bg-primary-light text-secondary"><?php echo autohive_like_it_button_html($item->ID, '', true) ?></span>
                                <a href="<?php echo get_the_permalink($item->ID) ?>">
                                    <h4><?php echo get_the_title($item->ID); ?></h4>
                                </a>
                                <div class="pricing-info d-flex align-items-center mt-4">
                                    <?php
                                    if (!empty($dailyRent)) {
                                        echo '<div class="info-left"><span class="text-secondary fw-semibold"><span class="h4 text-primary mb-0 d-inline-block">' . esc_html($dailyRent) . '</span> /Day</span></div>';
                                    }
                                    if (!empty($monthlyRent)) {
                                        echo '<div class="info-right ms-4"><span class="text-secondary fw-semibold"><span class="h4 mb-0 d-inline-block">' . esc_html($monthlyRent) . '</span> /Month</span></div>';
                                    }
                                    ?>
                                </div>
                                <p class="mt-4 mb-3"><?php echo get_the_excerpt($item->ID); ?></p>
                                <ul class="car-info mt-3 mb-30 fw-semibold fs-md">
                                    <?php
                                    if (!empty($passengers)) {
                                        echo '<li><span class="me-2"><i class="flaticon-drive"></i></span>Passengers: ' . esc_html($passengers) . '</li>';
                                    }
                                    if (!empty($suitcase)) {
                                        echo '<li><span class="me-2"><i class="flaticon-suitcase"></i></span>Suitcase: ' . esc_html($suitcase) . '</li>';
                                    }
                                    if (!empty($doors)) {
                                        echo '<li><span class="me-2"><i class="flaticon-car-door"></i></span>Doors: ' . esc_html($doors) . '</li>';
                                    }
                                    ?>
                                </ul>
                                <a href="<?php echo get_the_permalink($item->ID) ?>" class="btn btn-primary btn-sm"><?php echo esc_html($button_label) ?></a>
                            </div>
                        </div>
                <?php
                    }
                    wp_reset_postdata();
                }
                ?>
            </div>
        </div>
    </div>
</section>