<?php

$pickupLocation = !empty($_GET['pickup']) ? sanitize_text_field($_GET['pickup']) : '';
$pickTime       = !empty($_GET['pick-time']) ? sanitize_text_field($_GET['pick-time']) : '';
$returnLocation = !empty($_GET['return-location']) ? sanitize_text_field($_GET['return-location']) : '';
$returnTime     = !empty($_GET['return-time']) ? sanitize_text_field($_GET['return-time']) : '';

$paged      = (get_query_var('paged')) ? get_query_var('paged') : 1;
$args = [
    'post_type'     => 'autohive_rent',
    'post_status'   => 'publish',
    'orderby'       => 'meta_value',
    'paged'         => $paged
];

if (!empty($show_count)) {
    $args['posts_per_page'] = $show_count;
}

if (!empty($exclude)) {
    $args['post__not_in'] = $exclude;
}

if (!empty($order)) {
    $args['order'] = $order;
}

if (!empty($cats)) {
    $args['tax_query'] = [
        [
            'taxonomy' => 'autohive_rent_cat',
            'field' => 'slug',
            'terms' => $cats
        ]
    ];
}

if (!empty($pickupLocation || $pickTime || $returnLocation || $returnTime )) {

    $pickupLocation_arr = !empty($pickupLocation) ? ['key' => 'pickup_location', 'value'   => $pickupLocation, 'compare' => 'LIKE' ] : '';
    $pickTime_arr   	= !empty($pickTime) ? ['key' => 'available_days', 'value' => [ $pickTime, $returnTime ], 'compare' => 'BETWEEN' ] : '';
    $returnLocation_arr = !empty($returnLocation) ? ['key' => 'return_loacation', 'value'   => $returnLocation, 'compare' => 'LIKE'] : '';

    $args['meta_query'] = array(
        $pickupLocation_arr,
        $pickTime_arr,
        $returnLocation_arr
        
    );
}

$rent_posts = new \WP_Query($args); ?>

<section class="car-booking">
    <div class="row g-4">
        <?php
        if ($rent_posts->have_posts()) {
            while ($rent_posts->have_posts()) {
                $rent_posts->the_post();

                $dailyRent	= get_post_meta( get_the_ID(), 'daily_rent', true );
                $monthlyRent= get_post_meta( get_the_ID(), 'monthly_rent', true );
                $passengers	= get_post_meta( get_the_ID(), 'passengers', true );
                $suitcase	= get_post_meta( get_the_ID(), 'suitcase', true );
                $doors		= get_post_meta( get_the_ID(), 'car_doors', true ); 
                ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="car-card">
                        <?php 
                        if( has_post_thumbnail() ){ ?>
                            <div class="feature-img overflow-hidden">
                                <?php the_post_thumbnail( 'rent_520x350', array('class' => 'img-fluid') ) ?>
                            </div>
                            <?php 
                        } ?>
                        <div class="card-content bg-white position-relative">
                            <span class="star-rating rounded-pill position-absolute"><span class="me-1"><i class="fa-solid fa-star"></i></span>4.5</span>
                            <a href="<?php the_permalink() ?>">
                                <h5><?php the_title() ?></h5>
                            </a>
                            <div class="pricing-info d-flex align-items-center">
                                <?php 
                                if( !empty( $dailyRent ) ){
                                    echo '<div class="info-left"><span><strong class="text-primary fw-bold">'. esc_html( $dailyRent ) .'</strong> /Day</span></div>';
                                }
                                if( !empty( $monthlyRent ) ){
                                    echo '<div class="info-right ms-4"><span class="text-secondary"><strong class="fw-bold">'. esc_html( $monthlyRent ) .'</strong> /Month</span></div>';
                                }
                                ?>
                            </div>
                            <ul class="car-info mt-3">
                                <?php 
                                if( !empty( $passengers ) ){
                                    echo '<li><span class="me-2"><i class="flaticon-drive"></i></span>Passengers: '. esc_html( $passengers ) .'</li>';
                                }
                                if( !empty( $suitcase ) ){
                                    echo '<li><span class="me-2"><i class="flaticon-suitcase"></i></span>Suitcase: '. esc_html( $suitcase ) .'</li>';
                                }
                                if( !empty( $doors ) ){
                                    echo '<li><span class="me-2"><i class="flaticon-car-door"></i></span>Doors: '. esc_html( $doors ) .'</li>';
                                }
                                ?>
                            </ul>
                            <div class="card-btns mt-4">
                                <a href="<?php the_permalink() ?>" class="btn btn-secondary btn-sm">Booking Now</a>
                                <a href="<?php the_permalink() ?>" class="btn btn-sm ms-2 border">View Details</a>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
            }
            wp_reset_postdata();
        }
        else{
            echo '<h2>Your Query dose not match any post</h2>';
        }

        ?>
    </div>
</section>