<?php
$args = array(
    'post_type' => 'autohive_rent',
    'post_status' => 'publish',
);
if (!empty($show_count)) {
    $args['posts_per_page'] = $show_count;
}

if (!empty($exclude)) {
    $args['post__not_in'] = $exclude;
}

if (!empty($order)) {
    $args['order'] = $order;
}

if (!empty($orderby)) {
    $args['orderby'] = $orderby;
}

if (!empty($cats)) {
    $args['tax_query'] = [
        [
            'taxonomy' => 'autohive_rent_cat',
            'field' => 'slug',
            'terms' => $cats
        ]
    ];
}
$related_posts = get_posts($args); ?>
<section class="inventory-slider related_rent_car elementor-element" data-element_type="widget" data-widget_type="autohive_listing_rent.carousel">
    <div class="inventroy-slider swiper" 
        data-perpage="4" data-space="24" 
        data-next=".slider-btn-next" 
        data-prev=".slider-btn-prev" 
        data-loop="<?php echo $carousel_loop == 'yes' ? 'true' : 'false' ?>" 
        data-autoplay="<?php echo $carousel_autoplay == 'yes' ? 'true' : 'false' ?>" 
        data-speed="<?php echo esc_attr($slide_speed) ?>"
        data-breakpoints='{"1200": {"slidesPerView": <?php echo esc_attr($show_items_desktop) ?>}, "991": {"slidesPerView": <?php echo esc_attr($show_items_tablet) ?>}, "320": {"slidesPerView": <?php echo esc_attr($show_items_mobile) ?>}}'
    >
        <div class="swiper-wrapper">
            <?php
            if (is_array($related_posts) && count($related_posts) > 0) {
                foreach ($related_posts as $item) {
                    $dailyRent   = get_post_meta($item->ID, 'daily_rent', true);
                    $monthlyRent = get_post_meta($item->ID, 'monthly_rent', true);
                    $dealer      = get_post_meta($item->ID, 'select_dealer', true);
                    $passengers  = get_post_meta($item->ID, 'passengers', true);
                    $suitcase    = get_post_meta($item->ID, 'suitcase', true);
                    $doors       = get_post_meta($item->ID, 'car_doors', true);
                    $build_year  = get_post_meta($item->ID, 'build_year', true);
                    $car_engine_size      = get_post_meta(get_the_ID(), 'car_engine_size', true);
                    $car_transmissions    = get_post_meta(get_the_ID(), 'car_transmissions', true);
                    $car_type_of_drive    = get_post_meta(get_the_ID(), 'fuel_type', true); ?>

                    <div class="filter-card-item position-relative overflow-hidden rounded bg-white swiper-slide">
                        <?php
                        echo autohive_like_it_button_html($item->ID, 'icon-btn wish-btn position-absolute', true);
                        if ($build_year) { ?>
                            <span class="date position-absolute"><?php echo esc_html($build_year) ?></span>
                        <?php
                        }

                        if (has_post_thumbnail()) { ?>
                            <div class="feature-thumb position-relative overflow-hidden">
                                <a href="<?php echo get_the_permalink($item->ID) ?>">
                                    <?php echo get_the_post_thumbnail($item->ID, 'autohive_rent_760x580') ?>
                                </a>
                            </div>
                        <?php
                        } ?>

                        <div class="filter-card-content">
                            <?php
                            if (!empty($monthlyRent)) { ?>
                                <div class="price-btn text-end position-relative">
                                    <span class="small-btn-meta"><?php echo esc_html($monthlyRent) ?></span>
                                </div>
                            <?php
                            } ?>
                            <a href="<?php echo get_the_permalink($item->ID) ?>" class="mt-4 d-block">
                                <h5><?php echo get_the_title($item->ID); ?></h5>
                            </a>
                            <?php
                            if (!empty($dealer)) {
                                $dealer_details = get_post($dealer);
                                echo '<span class="meta-content"><strong>Listed by:</strong> <a href="' . get_the_permalink($dealer_details->ID) . '">' . esc_html($dealer_details->post_title) . '</a></span>';
                            }
                            ?>
                            <hr class="spacer mt-3 mb-3">
                            <div class="card-feature-box d-flex align-items-center mb-4">
                                <?php
                                if ($car_engine_size) { ?>
                                    <div class="icon-box d-flex align-items-center">
                                        <span class="me-2"><i class="flaticon-speedometer"></i></span>
                                        <?php echo esc_html($car_engine_size) ?>
                                    </div>
                                <?php
                                }
                                if ($car_transmissions) { ?>
                                    <div class="icon-box d-flex align-items-center">
                                        <span class="me-2"><i class="flaticon-steering-wheel"></i></span>
                                        <?php echo esc_html($car_transmissions) ?>
                                    </div>
                                <?php
                                }
                                if ($car_type_of_drive) { ?>
                                    <div class="icon-box d-flex align-items-center">
                                        <span class="me-2"><i class="flaticon-petrol"></i></span>
                                        <?php echo esc_html($car_type_of_drive) ?>
                                    </div>
                                <?php
                                }
                                ?>
                            </div>
                            <a href="<?php echo get_the_permalink($item->ID) ?>" class="btn outline-btn btn-sm d-block">View Details</a>
                        </div>
                    </div>
                <?php
                }
            }
            ?>
        </div>
    </div>
    <div class="slider-btn-prev swiper-btn"><i class="fa-solid fa-arrow-left"></i></div>
    <div class="slider-btn-next swiper-btn"><i class="fa-solid fa-arrow-right"></i></div>
</section>