<?php
$listing_post_ID    = get_the_ID();
$select_dealer      = get_post_meta($listing_post_ID, 'select_dealer', true);
$dealer_avatar      = get_post_meta($select_dealer, 'dealer_avatar', true);

if ( $select_dealer != '' ) {
    ?>
    <div class="iv_sidebar_widget iv_seller_widget">
        <div class="d-flex align-items-center">
            <?php echo wp_get_attachment_image($dealer_avatar['id'], 'autohive_100x100', '', array( 'class' => 'flex-shrink-0 rounded-circle' )) ?>
            <div class="iv_seller_info ms-4">
                <a href="<?php echo get_the_permalink($select_dealer) ?>" class="underline-none">
                    <h5 class="mb-0"><?php echo get_the_title($select_dealer) ?></h5>
                </a>
                <div class="rating">
                    <span>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                    </span>
                    <a href="#"><span class="ms-1">(5 reviews)</span></a>
                </div>
                <a href="<?php echo get_the_permalink($select_dealer) ?>">Other ads by this seller</a>
            </div>
        </div>
    </div>
    <?php
}
?>