<?php
$listing_post_ID	= get_the_ID();
$rent_or_sale  		= get_post_meta($listing_post_ID, 'rent_or_sale', true);
$listing_gallery	= get_post_meta($listing_post_ID, 'listing_thumb_gallery', true); ?>

<div class="product_details">
    <?php
    if (!empty($rent_or_sale)) {
        echo '<span class="btn-meta bg-primary text-white">' . esc_html($rent_or_sale) . '</span>';
    }
    ?>

    <h3 class="mt-2"><?php the_title() ?></h3>
    <div class="iv-meta">
        <span><i class="fa-solid fa-clock"></i>Listed on: <?php the_time(get_option('date_format')); ?></span>
        <span><i class="fa-solid fa-eye"></i>Views: <?php echo Autohive_Theme_Helper::get_post_views($listing_post_ID) ?></span>
        <span><?php echo autohive_like_it_button_html( get_the_ID(), '', true); ?></span>
    </div>
    <div class="iv_double_slider mt-30">
        <?php
        if (empty($listing_gallery)) {
            if (has_post_thumbnail()) {
                the_post_thumbnail('listing_810x490');
            }
        } else {
            $gallery_ids = explode(',', $listing_gallery);

            if (has_post_thumbnail()) {
                $thumb_id	= get_post_thumbnail_id();
                array_push($gallery_ids, $thumb_id);
            }

            if (is_array($gallery_ids)) { ?>

                <div class="iv_thumb_slider overflow-hidden" data-loop="true" data-perpage="1">
                    <div class="swiper-wrapper">
                        <?php
                        foreach ($gallery_ids as $gallery_id) { ?>
                            <div class="swiper-slide thumb-wrapper rounded overflow-hidden">
                                <?php echo wp_get_attachment_image($gallery_id, 'listing_810x490'); ?>
                            </div>
                        <?php
                        } ?>
                    </div>
                </div>
                <div class="iv_thumb_control_slider overflow-hidden mt-3 mt-lg-4" data-loop="false" data-perpage="4">
                    <div class="swiper-wrapper">
                        <?php
                        foreach ($gallery_ids as $gallery_id) { ?>
                            <div class="swiper-slide rounded overflow-hidden">
                                <?php echo wp_get_attachment_image($gallery_id, 'listing_185x122'); ?>
                            </div>
                        <?php
                        } ?>

                    </div>
                </div>

        <?php
            }
        }
        ?>
    </div>
</div>