<?php
$meta_features = get_post_meta(get_the_ID(), 'car_features_tab', true);

?>

<div class="iv_feature_accordion">
    <div class="accordion" id="iv_ft_accordion">
        <?php
        if (!empty($meta_features) && is_array($meta_features)) {
            foreach ($meta_features as $key => $features) {
                $show       = $key == 0 ? 'show' : '';
                $collapsed  = $key > 0 ? 'collapsed' : '';

                $tab_id = sanitize_title_with_dashes($features['features_tab_title']); ?>
                <div class="accordion-item">
                    <div class="accordion-header">
                        <a href="#<?php echo esc_attr($tab_id . $key) ?>" class="accordion-button <?php echo esc_attr( $collapsed ) ?>" data-bs-toggle="collapse"><?php echo esc_html($features['features_tab_title']) ?></a>
                    </div>

                    <div class="accordion-collapse collapse <?php echo esc_attr( $show ) ?>" id="<?php echo esc_attr($tab_id . $key) ?>" data-bs-parent="#iv_ft_accordion">
                        <div class="accordion-body">
                            <div class="row">
                                
                                <?php
                                $features_array = array_chunk( $features['car_features'], 4 );
                                if( !empty( $features_array ) && is_array( $features_array ) ){
                                    foreach ( $features_array as $feature) {
                                        echo '<div class="col-sm-4"><ul class="iv_ft_list">';
                                        if( !empty( $feature ) && is_array( $feature ) ){
                                            foreach( $feature as $item ){
                                                echo '<li><span class="me-2"><i class="fa-solid fa-check"></i></span>' . esc_html($item['feature_item']) . '</li>';
                                            }
                                        }
                                        echo '</ul></div>';
                                    }
                                }
                                ?>
                                    

                            </div>
                        </div>
                    </div>

                </div>
            <?php
            }
        }
        ?>
    </div>
</div>