<section class="brands-section">
    <div class="container">
        <div class="ct-row d-flex align-items-center justify-content-center flex-wrap">
            <?php
            $inventory_page = !empty($inventory_page_url['url']) ? $inventory_page_url['url'] : '#';
            $args = array(
                'post_type' => 'autohive_listing',
                'posts_per_page' => -1,
                'post_status' => 'publish',
            );

            $postslist = get_posts($args);
            $bodyType = array();
            if( !empty( $postslist ) && is_array( $postslist ) ){
                foreach ( $postslist as $key => $item ) {
                    $meta = get_post_meta($item->ID, 'car_body_type', true);
                    $bodyType[$item->ID] = $meta;
                }
                $bodyType = array_unique( $bodyType );
            }
           

            $options = get_option('autohive_cs_opt');
            $bodyTypeOption = $options['car_body_type_group'];
            $item_array = array();
            if ( is_array($bodyTypeOption) ) {
                foreach ($bodyTypeOption as $key => $itemOption) {
                    $bodyTypeIndex = str_replace(' ', '-', $itemOption['body_type_name']);
                    $item_array[strtolower($bodyTypeIndex)] =  $itemOption;
                }
            }
            
            if( is_array( $bodyType ) && count($bodyType) > 0 ) {
                foreach ($bodyType as $key => $item) { 
                    if ( !empty( $item_array) ) {
                        $used_bodyType = $item_array[$item];
                        ?>
                        <div class="ct-col">
                            <a href="<?php echo esc_url( $inventory_page ) ?>?car_body_type=<?php echo esc_attr($item) ?>">
                                <div class="brand-card text-center bg-white position-relative rounded">
                                    <?php
                                    if (!empty($used_bodyType['body_type_img']['url'])) {
                                        echo '<img src="' . esc_url($used_bodyType['body_type_img']['url']) . '" alt="'. esc_attr( $used_bodyType['body_type_name'] ) .'" class="img-fluid">';
                                    } ?>
                                    <h5 class="mt-3 mb-0"><?php echo esc_html( $used_bodyType['body_type_name']) ?></h5>
                                    <span class="explore-btn position-absolute text-white"><i class="fa-solid fa-arrow-right-long"></i></span>
                                </div>
                            </a>
                        </div>
                        <?php
                    }
                }
            } ?>
        </div>
    </div>
</section>