<div class="brands-filter">
    <ul class="nav nav-tabs border-0 justify-content-center flex-wrap">
        <?php
        $inventory_page = !empty($inventory_page_url['url']) ? $inventory_page_url['url'] : '#';
        $listingBrands = array_column($listing_brands, 'select_brand');
        $getBrands     = array_unique($listingBrands);
        $brandTabData  = return_tab_data($getBrands, $listing_brands, 'select_brand');
        $brands = get_terms(array(
            'taxonomy' => 'autohive_listing_brand',
            'hide_empty' => true
        ));

        if (is_array($getBrands) && count($getBrands) > 0) {
            $i = 1;
            foreach ($getBrands as $brand) {
                $tagforfilter = sanitize_title_with_dashes($brand);
                $brandForFilter = str_replace('-', '', $tagforfilter);
                $listingBrandName = get_term_by('slug', $brand, 'autohive_listing_brand');
                $meta = get_term_meta($listingBrandName->term_id, 'autohive_taxonomy_options', true);

                $active = $i == 1 ? ' active ' : '';

                echo '<li><a href="#' . esc_attr($brandForFilter) . '" data-brand="' . esc_attr($brand) . '" class="brand_tab ' . esc_attr($active) . esc_attr($brandForFilter) . '" data-bs-toggle="tab">';
                echo wp_get_attachment_image($meta['autohive_listing_brand_icon']['id'], 'full', '', array('class' => 'icon-red'));
                echo wp_get_attachment_image($meta['listing_brand_icon_hover']['id'], 'full', '', array('class' => 'icon-white'));
                echo '<span class="ms-4">' . esc_html($brand) . '</span></a></li>';

                $i++;
            }
        } ?>

    </ul>
    <div class="tab-content mt-5">
        <?php
        if (!empty($brandTabData)) {
            $i = 1;
            foreach ($brandTabData as $key => $val) {

                $tagforfilter = sanitize_title_with_dashes($key);
                $brandForFilter = str_replace('-', '', $tagforfilter);
                $active = $i == 1 ? ' show active' : ''; ?>

                <div class="tab-pane fade <?php echo esc_attr($active) ?>" id="<?php echo esc_attr($brandForFilter) ?>">
                    <div class="car_body_types _<?php echo esc_attr($i++) ?> ct-row d-flex align-items-center justify-content-center flex-wrap">
                        <?php
                        $args = array(
                            'post_type' => 'autohive_listing',
                            'posts_per_page' => -1,
                            'tax_query' => array(
                                array(
                                    'taxonomy' => 'autohive_listing_brand',
                                    'field'    => 'slug',
                                    'terms'    => $key,
                                ),
                            ),

                        );

                        $postslist = get_posts($args);
                        $bodyType = array();
                        if (!empty($postslist)) {
                            foreach ($postslist as $key => $item) {
                                $meta = get_post_meta($item->ID, 'car_body_type', true);
                                $bodyType[$item->ID] = $meta;
                            }
                        }
                        $bodyType = array_unique($bodyType);


                        $options = get_option('autohive_cs_opt');
                        $bodyTypeOption = $options['car_body_type_group'];
                        $item_array = array();
                        if (is_array($bodyTypeOption) && !empty($bodyTypeOption)) {
                            foreach ($bodyTypeOption as $key => $itemOption) {
                                $bodyTypeIndex = str_replace(' ', '-', $itemOption['body_type_name']);
                                $item_array[strtolower($bodyTypeIndex)] =  $itemOption;
                            }
                        }

                        $all_data = array();
                        if (!empty($bodyType) && is_array($bodyType)) {
                            foreach ($bodyType as $key => $body) {
                                $all_data[$key] =  $item_array[$body];
                            }
                        }

                        $aa = array();
                        if (!empty($all_data) && is_array($all_data)) {
                            foreach ($all_data as $item) {
                                $aa[] = $item;
                            }
                        }
                        if (!empty($aa) && is_array($aa)) {
                            foreach ($aa as $item_) {
                                $bodyTypeSlug = str_replace(' ', '-', $item_['body_type_name']); ?>
                                <div class="ct-col">
                                    <a href="<?php echo esc_url($inventory_page) ?>?car_body_type=<?php echo esc_attr(strtolower($bodyTypeSlug)) ?>" class="ct-col">
                                        <div class="brand-card text-center bg-white position-relative rounded">
                                            <img src="<?php echo esc_url($item_['body_type_img']['url']) ?>" alt="<?php echo esc_attr($item_['body_type_name']) ?>" class="img-fluid">
                                            <h5 class="mt-3 mb-0"><?php echo $item_['body_type_name']; ?></h5>
                                            <span class="explore-btn position-absolute text-white"><i class="fa-solid fa-arrow-right-long"></i></span>
                                        </div>
                                    </a>
                                </div>
                        <?php
                            }
                        } ?>

                    </div>
                </div>
        <?php
            }
        }
        ?>
    </div>
</div>