<section class="dealership-hero position-relative overflow-hidden">
	<div class="swiper at-hero-slider-wrapper"
	     data-effect="fade"
	     data-pagination=".swiper-pagination"
	     data-paginationtype="bullets"
	     data-perpage="1"
	     data-loop="<?php echo $carousel_loop == 'yes' ? 'true' : 'false' ?>"
	     data-autoplay="<?php echo $carousel_autoplay == 'yes' ? 'true' : 'false' ?>"
	     data-speed="<?php echo esc_attr( $slide_speed ) ?>" >
		<div class="swiper-wrapper">
			<?php
			if( is_array( $autohive_slides ) ){
				foreach( $autohive_slides as $slide ){ ?>
					<div class="swiper-slide">
						<div class="dl-hero-single elementor-repeater-item-<?php echo esc_attr( $slide['_id'] ) ?>">
							<div class="container">
								<div class="at_hero_slider">
									<div class="row">
										<div class="col-xl-7">
											<div class="at-hero-title">
												<?php
												if( !empty( $slide['slide_subtitle'] ) ){
													echo '<span class="at-subtitle text-primary position-relative fw-bold">'. autohive_kses_post( $slide['slide_subtitle'] ) .'</span>';
												}
												if( !empty( $slide['slide_title'] ) ){
													echo '<h1 class="text-white mb-4 mt-3 display-4">'. autohive_kses_post( $slide['slide_title'] ) .'</h1>';
												}
												if( !empty( $slide['slide_desc'] ) ){
													echo '<p class="mb-30">'. autohive_kses_post( $slide['slide_desc'] ) .'</p>';
												}

												$table_contents = preg_split( '/\r\n|[\r\n]/', $slide['feature_list'] );
												if( !empty( $table_contents ) ){
													echo '<ul class="car-info mt-3 mb-30 fs-md fw-500">';
													foreach( $table_contents as $item ){
														echo '<li class="pt-1"><span class="me-2"><i class="fa-regular fa-circle-check"></i></span>'. esc_html( $item ) .'</li>';
													}
													echo '</ul>';
												}

												if( !empty( $slide['btn_label'] ) ){
													echo '<a href="'. esc_url( $slide['btn_url']['url'] ) .'" class="at-explore-btn"><span class="me-2"><svg width="49" height="28" viewBox="0 0 49 28" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M42.5 9L47.715 14.1189M47.715 14.1189L42.5 19.3339M47.715 14.1189H19.5" stroke="#FC0012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><rect x="1" y="1" width="32" height="26" rx="13" stroke="#FC0012" stroke-width="2"/></svg></span>'. esc_html( $slide['btn_label'] ) .'</a>';
												}
												?>
											</div>
										</div>
										<div class="col-xl-5">
											<div class="at-hero-banner position-relative mt-4 mt-sm-0">
												<?php
												if( !empty( $slide['feature_image']['url'] ) ){
													echo '<img src="'. esc_url( $slide['feature_image']['url'] ) .'" class="at_hero_car" alt="'. esc_attr( $slide['slide_title'] ) .'">';
												}
												?>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
			}
			?>
		</div>
		<div class="swiper-pagination"></div>
	</div>
	<?php
	if( $is_scroll_down == 'yes' ){ ?>
		<a href="<?php echo esc_attr( $scroll_down_sec_id ) ?>" class="position-absolute btn-scroll-down d-none d-xl-block"><span class="me-2">
				<svg width="49" height="28" viewBox="0 0 49 28" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M42.5 9L47.715 14.1189M47.715 14.1189L42.5 19.3339M47.715 14.1189H19.5" stroke="#FC0012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
					<rect x="1" y="1" width="32" height="26" rx="13" stroke="#FC0012" stroke-width="2"/>
				</svg>
				</span> <?php echo esc_html( $scroll_down_label ) ?>
		</a>
		<?php
	}

	if( $is_social_icons == 'yes' ){ ?>
		<div class="at-header-social d-none d-sm-flex align-items-center position-absolute">
			<?php
			if( !empty( $follow_on_text ) ){
				echo '<span class="title">'. esc_html( $follow_on_text ) .'</span>';
			}
			?>
			<!--Social icon will come from theme option-->
			<ul class="social-list ms-3">
                
                <?php
                if ( $social_icons != '' ) {
                    foreach ( $social_icons as $icon ) {
                        ?>
                        <li>
                            <a <?php Autohive_Core_Helper::the_button($icon['icon_url']) ?>>
                                <?php Elementor\Icons_Manager::render_icon($icon['icon']) ?>
                            </a>
                        </li>
                        <?php
                    }
                }
                ?>
			</ul>
		</div>
		<?php
	}
	?>
</section>