<div class="faq-section">
    <div class="faq-tabs brands-filter">
        <ul class="nav nav-tabs border-0 justify-content-center">
            <?php
            if ( !empty($settings['cats']) ) {
                foreach ( $settings['cats'] as $index => $cat ) {
                    $cat_list = get_term_by( 'slug',$cat, 'faq_cat' );
                    $tab_count = $index + 1;
                    $tab_category_setting_key = $this->get_repeater_setting_key( 'tab_li', '', $index );
                    $active = $tab_count == 1 ? ' active' : '';
                    $this->add_render_attribute( $tab_category_setting_key, [
                        'href' => '#'.$cat_list->slug,
                        'class' => $active,
                        'data-bs-toggle' => 'tab',
                    ]);

	                $meta = get_term_meta( $cat_list->term_id, 'faq_cat', true );
	                $icon_class = !empty($meta['faq_icon']) ? $meta['faq_icon'] : '';
                    ?>
                    <li>
                        <a <?php echo $this->get_render_attribute_string( $tab_category_setting_key ); ?>>
                            <?php if ($icon_class) : ?>
                                <span class="me-2"><i class="<?php echo esc_attr($icon_class) ?>"></i></span>
                            <?php endif; ?>
                            <?php echo esc_html( $cat_list->name ) ?>
                        </a>
                    </li>
                    <?php
                }
            }
            ?>
        </ul>
        <div class="tab-content mt-60">
            <?php
            if ( $settings['cats'] != '' ) {
	            foreach ( $settings['cats'] as $index => $cat ) {
		            $cat_list = get_term_by( 'slug',$cat, 'faq_cat' );
		            $tab_count = $index + 1;
		            $tab_content_setting_key = $this->get_repeater_setting_key( 'tab_content', '', $index );
		            $show_active = $tab_count == 1 ? ' active show' : '';
		            $this->add_render_attribute( $tab_content_setting_key, [
			            'class' => 'tab-pane fade' . $show_active,
			            'id' => $cat_list->slug,
			            'role' => 'tabpanel'
		            ]);
		            ?>
                    <div <?php echo $this->get_render_attribute_string( $tab_content_setting_key ); ?>>
                        <div class="row g-4 mt-4">
                            <div class="col-sm-12 col-md-6 mt-0">
                                <?php
                                $faqs = new WP_Query( array(
                                    'post_type'      => 'faq',
                                    'posts_per_page' => $show_count,
                                    'order' => !empty($settings['order']) ? $settings['order'] : '',
                                    'tax_query' => array(
                                        array(
                                            'taxonomy' => 'faq_cat',
                                            'field'    => 'slug',
                                            'terms'    => $cat_list->slug,
                                        ),
                                    ),
                                ));
                                if( $faqs->have_posts() ){
                                    $faq_half  = $faqs->post_count / 2;
                                    $faqHalf   = round( $faq_half, 0, PHP_ROUND_HALF_UP);

                                    $i = 0;
                                    while ( $faqs->have_posts() ) {
                                        $faqs->the_post();
                                        $collapsed      = $i == 0 || $i == $faqHalf ? '' : ' collapsed';
                                        $collapse_show  = $i == 0 || $i == $faqHalf ? ' show' : '';
                                        
                                        if( $i == $faqHalf ){
                                            echo '</div><div class="col-sm-12 col-md-6 mt-0">';
                                        } ?>
                                        
                                            <div class="accordion theme-accordion" id="accordion_<?php echo get_the_ID() ?>">
                                                <div class="accordion-item">
                                                    <div class="accordion-header">
                                                        <a href="#ac_<?php echo get_the_ID() ?>" class="accordion-button<?php echo esc_attr($collapsed) ?>" data-bs-toggle="collapse">
                                                            <?php the_title() ?>
                                                        </a>
                                                    </div>
                                                    <div class="accordion-collapse collapse<?php echo esc_attr($collapse_show) ?>" id="ac_<?php echo get_the_ID() ?>" data-bs-parent="#accordion_<?php echo get_the_ID() ?>">
                                                        <div class="accordion-body">
                                                            <?php the_content() ?>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        
                                        <?php
                                        ++$i;
                                    }
                                }
                                wp_reset_postdata();
                                ?>
                            </div>
                        </div>
                    </div>
		            <?php
	            }
            }
            ?>
        </div>
    </div>
</div>