<?php
if (is_singular('listing_dealer')) {
    $locations      = get_post_meta(get_the_ID(), 'dealer_locations', true);
    $contact_num    = get_post_meta(get_the_ID(), 'dealer_contact_num', true);
    $dealer_email   = get_post_meta(get_the_ID(), 'dealer_email', true);
    $social_icons   = get_post_meta(get_the_ID(), 'dealer_social_icons', true);
    $opening_closed = get_post_meta(get_the_ID(), 'opening_closed', true);
	$listing_dealer_count = count(Autohive_Core_Helper::autohive_dealer_posts(get_the_ID()));
    ?>
    <div class="dealer-single-info bg-white rounded d-lg-flex align-items-center">
        <div class="dl_single_left rounded position-relative flex-shrink-0">
            <?php the_post_thumbnail('dealer_280x250', array('class' => 'img-fluid rounded')); ?>
            <span class="listing-count bg-white shadow py-1 px-3 fw-semibold rounded position-absolute start-0 bottom-0">
                <?php printf(_n('%s Listing', '%s Listings', $listing_dealer_count, 'autohive-core'), $listing_dealer_count) ?>
            </span>
        </div>
        <div class="dl_single_right ms-lg-4 mt-4 mt-lg-0">
            <h4 class="mb-0 mt-1"><?php the_title(); ?></h4>
            <div class="info-meta mt-1">
                <?php
                if (!empty($locations)) {
                    echo '<span><i class="fa-solid fa-location-dot"></i>' . esc_html($locations) . '</span>';
                    echo '<a href="https://www.google.com/maps/dir/my+location/' . esc_attr($locations) . '" target="_blank" class="ms-3">Get Directions</a>';
                }
                ?>
            </div>
            <p class="mt-3"><?php the_excerpt() ?></p>
            <ul class="dl_info_meta d-flex align-items-center flex-wrap">
                <?php
                if (!empty($contact_num)) {
                    $number_ = str_replace(' ', '', $contact_num);
                    echo '<li><a href="tel:' . esc_attr($number_) . '"><span class="me-2"><i class="fa-brands fa-whatsapp"></i></span>' . esc_html($contact_num) . '</a></li>';
                }
                if (!empty($dealer_email)) {
                    echo '<li><a href="mailto:' . esc_attr($dealer_email) . '"><span class="me-2"><i class="fa-solid fa-envelope"></i></span>' . esc_html($dealer_email) . '</a></li>';
                }
                if (!empty($opening_closed)) {
                    echo '<li><span class="me-2"><i class="fa-regular fa-clock"></i></span>' . $opening_closed['from'] . '-' . $opening_closed['to'] . '</li>';
                }
                ?>
            </ul>
            <!--<div class="review_share_btns mt-20">
                <a href="#respond"><span class="me-2"><i class="fa-solid fa-star"></i></span>Write a Review</a>
                <a href="#"><i class="fa-solid fa-share-nodes"></i></a>
            </div>-->
        </div>
    </div>
<?php
} else {
    echo '<h2>Layout: Delar Details only for Dealer details page</h2>';
} ?>