<div class="dealer-single-tab">
    <ul class="nav nav-tabs">
        <li><a href="#inventory" class="active" data-bs-toggle="tab">Dealer's Inventory</a></li>
        <li><a href="#review-box" data-bs-toggle="tab">Dealer's Write a Review</a></li>
    </ul>
    <div class="tab-content mt-30">
        <div class="tab-pane fade active show" id="inventory">
            <div class="row g-4">
                <?php
                $dealer      = get_post_meta( get_the_ID(), 'select_dealer', true);
                $paged      = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $args = array(
                    'post_type'     => 'autohive_listing',
                    'post_status'   => 'publish',
                    'paged'         => $paged,
                );

                if ( $show_count != '' ) {
                    $args ['posts_per_page'] = $show_count;
                }

                if ( $dealer != '' ) {
                    $args['meta_query'] = [
                        [
                            'key'  => 'select_dealer',
                            'value'     => get_the_ID(),
                        ]
                    ];
                }

                $dealer_inventory = new \WP_Query($args);

                if ( $dealer_inventory->have_posts() ) {
                    while ( $dealer_inventory->have_posts() ) {
                        $dealer_inventory->the_post();
                        $dailyRent   = get_post_meta( get_the_ID(), 'daily_rent', true);
                        $monthlyRent = get_post_meta( get_the_ID(), 'monthly_rent', true);
                        $dealer      = get_post_meta( get_the_ID(), 'select_dealer', true);
                        $passengers  = get_post_meta( get_the_ID(), 'passengers', true);
                        $suitcase    = get_post_meta( get_the_ID(), 'suitcase', true);
                        $doors       = get_post_meta( get_the_ID(), 'car_doors', true);
                        $build_year  = get_post_meta( get_the_ID(), 'build_year', true);
                        $car_engine_size      = get_post_meta( get_the_ID(), 'car_engine_size', true);
                        $car_transmissions    = get_post_meta( get_the_ID(), 'car_transmissions', true);
                        $car_type_of_drive    = get_post_meta( get_the_ID(), 'fuel_type', true); ?>

                        <div class="col-xxl-4 col-md-6">
                            <div class="filter-card-item position-relative overflow-hidden rounded bg-white">
                                <?php
                                echo autohive_like_it_button_html( get_the_ID(), 'icon-btn wish-btn position-absolute', true);
                                if ($build_year) { ?>
                                    <span class="date position-absolute"><?php echo esc_html($build_year) ?></span>
                                <?php
                                }

                                if (has_post_thumbnail()) { ?>
                                    <div class="feature-thumb position-relative overflow-hidden">
                                        <a href="<?php the_permalink() ?>">
                                            <?php the_post_thumbnail('autohive_rent_760x580') ?>
                                        </a>
                                    </div>
                                <?php
                                } ?>

                                <div class="filter-card-content">
                                    <?php
                                    if (!empty($monthlyRent)) { ?>
                                        <div class="price-btn text-end position-relative">
                                            <span class="small-btn-meta"><?php echo esc_html($monthlyRent) ?></span>
                                        </div>
                                    <?php
                                    } ?>
                                    <a href="<?php the_permalink() ?>" class="mt-4 d-block">
                                        <h5><?php the_title(); ?></h5>
                                    </a>
                                    <?php
                                    if (!empty($dealer)) {
                                        $dealer_details = get_post($dealer);
                                        echo '<span class="meta-content"><strong>Listed by:</strong> <a href="' . get_the_permalink($dealer_details->ID) . '">' . esc_html($dealer_details->post_title) . '</a></span>';
                                    }
                                    ?>
                                    <hr class="spacer mt-3 mb-3">
                                    <div class="card-feature-box d-flex align-items-center mb-4">
                                        <?php
                                        if ($car_engine_size) { ?>
                                            <div class="icon-box d-flex align-items-center">
                                                <span class="me-2"><i class="flaticon-speedometer"></i></span>
                                                <?php echo esc_html($car_engine_size) ?>
                                            </div>
                                        <?php
                                        }
                                        if ($car_transmissions) { ?>
                                            <div class="icon-box d-flex align-items-center">
                                                <span class="me-2"><i class="flaticon-steering-wheel"></i></span>
                                                <?php echo esc_html($car_transmissions) ?>
                                            </div>
                                        <?php
                                        }
                                        if ($car_type_of_drive) { ?>
                                            <div class="icon-box d-flex align-items-center">
                                                <span class="me-2"><i class="flaticon-petrol"></i></span>
                                                <?php echo esc_html($car_type_of_drive) ?>
                                            </div>
                                        <?php
                                        }
                                        ?>
                                    </div>
                                    <a href="<?php the_permalink() ?>" class="btn outline-btn btn-sm d-block">View Details</a>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    wp_reset_postdata();
                }
                ?>


            </div>
            <div class="template-pagination mt-5 pg-style-2 dealer_pagination">
                <?php
                $big = 999999999; // need an unlikely integer
                echo paginate_links(array(
                    'base'      => str_replace($big, '%#%', get_pagenum_link($big)),
                    'format'    => '?paged=%#%',
                    'current'   => max(1, get_query_var('paged')),
                    'total'     => $dealer_inventory->max_num_pages,
                    'type'      => 'list',
                    'prev_text' => __('<i class="fa-solid fa-angles-left"></i>'),
                    'next_text' => __('<i class="fa-solid fa-angles-right"></i>'),
                ));
                ?>
            </div>
        </div>
        <div class="tab-pane fade" id="review-box">
            <div class="review_box bg-white p-4 rounded">
                <?php
                if (comments_open() || get_comments_number()) :
                    comments_template();
                endif;
                ?>
            </div>
        </div>
    </div>
</div>