<section class="dealership-slider-area">
    <div class="dealership-slider overflow-hidden">
        <div class="swiper-wrapper">
			<?php
			while ($dealer_lists->have_posts()) : $dealer_lists->the_post();
				$locations = get_post_meta( get_the_ID(), 'dealer_locations', true);
				$contact_num = get_post_meta(get_the_ID(), 'dealer_contact_num', true);
				$dealer_email = get_post_meta(get_the_ID(), 'dealer_email', true);
				?>
                <div class="dealership-single pt-3 pb-30 px-3 bg-white rounded swiper-slide">
                    <a href="<?php the_permalink() ?>">
						<?php the_post_thumbnail( 'autohive_274x194', array( 'class' => 'img-fluid rounded' ) ) ?>
                    </a>
                    <a href="<?php the_permalink(); ?>">
                        <h4 class="mt-4 mb-3 __title"><?php echo Autohive_Core_Helper::get_the_title_length($settings,'title_length') ?></h4>
                    </a>
                    <ul class="dealers-info">
						<?php
						if ( $locations != '' ) { ?>
                            <li class="d-flex align-items-center">
                                <span><i class="fa-sharp fa-solid fa-location-dot"></i></span>
                                <span class="info-text ms-3"><?php echo Autohive_Core_Helper::kses_post($locations) ?></span>
                            </li>
							<?php
						}
						if ( $contact_num != '' ) { ?>
                            <li class="d-flex align-items-center">
                                <span><i class="fa-brands fa-whatsapp"></i></span>
                                <span class="info-text ms-3"><?php echo esc_html($contact_num) ?></span>
                            </li>
							<?php
						}
						if ( $dealer_email != '' ) { ?>
                            <li class="d-flex align-items-center">
                                <span><i class="fa-regular fa-envelope"></i></span>
                                <span class="info-text ms-3"><?php echo esc_html($dealer_email) ?></span>
                            </li>
							<?php
						}
						?>
                    </ul>
                    <a href="<?php the_permalink(); ?>" class="map-btn mt-4 d-inline-block __btn">
						<?php echo esc_html($view_details) ?>
                        <span class="ms-1"><i class="fa-solid fa-caret-right"></i></span>
                    </a>
                </div>
			<?php
			endwhile;
			wp_reset_postdata();
			?>
        </div>
        <div class="swiper-pagination position-relative mt-4 bottom-0"></div>
    </div>
</section>