<?php
$args = [
    'post_type' => 'autohive_listing',
    'post_status' => 'publish',
    'posts_per_page' => $show_count != '' ? $show_count : '',
    'orderby'       => 'date',
	'order'         => 'DESC',
];
$product_list = new \WP_Query( $args );
?>
<ul class="dl_posts">
    <?php
    while ($product_list->have_posts()) : $product_list->the_post();
        $locations = get_post_meta( get_the_ID(), 'car_location', true);
        $price = get_post_meta( get_the_ID(), 'regular_price', true);
        ?>
        <li class="d-flex align-items-center">
            <div class="thumb-wrapper rounded-1 overflow-hidden flex-shrink-0">
                <a href="<?php the_permalink() ?>">
                    <?php the_post_thumbnail('autohive_72x72', [ 'class' => 'img-fluid' ]) ?>
                </a>
            </div>
            <div class="dl_post_content ms-3">
                <a href="<?php the_permalink(); ?>">
                    <h6 class="mb-1 __title"><?php echo Autohive_Core_Helper::get_the_title_length($settings,'title_length') ?></h6>
                </a>
                <?php
                if ( $locations != '' ) {
                    echo '<span class="meta-text"><i class="fa-solid fa-location-dot __locations"></i>'.$locations.'</span>';
                }
                if ( $price != '' ) {
                    echo '<span class="text-primary fw-semibold price">'.$price.'</span>';
                }
                ?>
            </div>
        </li>
        <?php
    endwhile;
    wp_reset_postdata();
    ?>
</ul>