<div class="dl_sidebar_widget dl_slider_widget overflow-hidden p-0">
    <?php if ( $title != '' ) : ?>
        <h5 class="mb-3"><?php echo esc_html($title) ?></h5>
    <?php endif ?>
    <div class="dl_slider_wrapper">
        <?php
        while ( $dealer_lists->have_posts() ) : $dealer_lists->the_post();
            $locations      = get_post_meta( get_the_ID(), 'dealer_locations', true);
            $contact_num    = get_post_meta( get_the_ID(), 'dealer_contact_num', true);
            $social_icons   = get_post_meta( get_the_ID(), 'dealer_social_icons', true);
	        $listing_dealer_count = count(Autohive_Core_Helper::autohive_dealer_posts(get_the_ID()));
            ?>
            <div class="dl_card_box bg-white">
                <div class="figure_img position-relative">
                    <a href="<?php the_permalink() ?>">
                        <?php the_post_thumbnail( 'autohive_525x310', array( 'class' => 'img-fluid' ) ) ?>
                    </a>
                    <span class="listing-count bg-white text-primary fw-500 rounded-1 shadow py-1 px-3 position-absolute start-0 bottom-0">
                        <?php printf(_n('%s Listing', '%s Listings', $listing_dealer_count, 'autohive-core'), $listing_dealer_count ) ?>
                    </span>
                </div>
                <a href="<?php the_permalink(); ?>">
                    <h5 class="mt-4 __title"><?php echo Autohive_Core_Helper::get_the_title_length($settings,'title_length') ?></h5>
                </a>
                <?php
                if ( $locations != '' ) {
                    echo '<span class="slide_meta_text d-block __location"><i class="fa-solid fa-location-dot"></i>'.$locations.'</span>';
                }
                if ( $contact_num != '' ) {
                    echo '<span class="slide_meta_text d-block phone mt-2 __contact_num"><i class="fa-brands fa-whatsapp"></i>'.$contact_num.'</span>';
                }
                ?>
                <hr class="mt-3 mb-3">
                <div class="dl_social d-flex align-items-center">
                    <?php
                    if ( $social_icons !='' ) {
                        foreach ( $social_icons as $item ) {
                            $social_icon = !empty($item['social_icon']) ? $item['social_icon'] : '';
                            $icon_url = !empty($item['social_icon_url']) ? $item['social_icon_url'] : '';
                            ?>
                            <a href="<?php echo esc_url($icon_url) ?>" class="__icons">
                                <i class="<?php echo esc_attr($social_icon) ?>"></i>
                            </a>
                            <?php
                        }
                    }
                    ?>
                </div>
            </div>
            <?php
        endwhile;
        wp_reset_postdata();
        ?>
    </div>
</div>