<div class="dl_listing">
    <div class="iv_listing_top d-flex flex-wrap align-items-center bg-white justify-content-center justify-content-sm-between rounded mb-4">
	    <?php
	    if ($dealer_lists->have_posts()) {
		    echo '<p class="mb-0 fw-500 d-inline-block">Showing ' . absint($paged) . ' - ' .  esc_html($dealer_lists->max_num_pages) . ' of ' . absint($dealer_lists->found_posts) . ' Results</p>';
	    } else {
		    echo '<p class="mb-0 fw-500 d-inline-block">No post found</p>';
	    }
	    ?>
        <form class="iv_listing_filter_menu d-flex flex-wrap align-items-center justify-content-center autohive_listing_filter" method="get">
            <p class="mb-0 flex-shrink-0 fw-semibold">Sort by:</p>
            <select class="form-select fw-500 order_by" name="order_by">
                <option value="new" <?php echo esc_attr($order_by == 'new' ? 'selected' : '') ?>>Newest First</option>
                <option value="popular" <?php echo esc_attr($order_by == 'popular' ? 'selected' : '') ?>>Most Popular</option>
                <option value="rated" <?php echo esc_attr($order_by == 'rated' ? 'selected' : '') ?>>Most Rated</option>
            </select>
        </form>
    </div>
    <div class="row g-4">
        <?php
        while ($dealer_lists->have_posts()) : $dealer_lists->the_post();
            $locations = get_post_meta( get_the_ID(), 'dealer_locations', true);
            $contact_num = get_post_meta(get_the_ID(), 'dealer_contact_num', true);
            $social_icons = get_post_meta(get_the_ID(), 'dealer_social_icons', true);
	        $listing_dealer_count = count(Autohive_Core_Helper::autohive_dealer_posts(get_the_ID()));
            ?>
            <div class="col-lg-4 col-sm-6">
                <div class="dl_card_box bg-white pt-3 px-3 pb-4 rounded">
                    <div class="figure_img position-relative">
                        <a href="<?php the_permalink() ?>">
                            <?php the_post_thumbnail( 'autohive_525x310', array( 'class' => 'img-fluid' ) ) ?>
                        </a>
                        <span class="listing-count bg-white text-primary fw-500 rounded-1 shadow py-1 px-3 position-absolute start-0 bottom-0">
                            <?php printf(_n('%s Listing', '%s Listings', $listing_dealer_count, 'autohive-core'), $listing_dealer_count ) ?>
                        </span>
                    </div>
                    <a href="<?php the_permalink() ?>">
                        <h5 class="mt-4 __title"><?php echo Autohive_Core_Helper::get_the_title_length($settings,'title_length') ?></h5>
                    </a>
                    <?php
                    if ( $locations != '' ) {
                        echo '<span class="slide_meta_text d-block __location"><i class="fa-solid fa-location-dot"></i>'.$locations.'</span>';
                    }
                    if ( $contact_num != '' ) {
                        echo '<span class="slide_meta_text d-block phone mt-2 __contact_num"><i class="fa-brands fa-whatsapp"></i>'.$contact_num.'</span>';
                    }
                    ?>
                    <hr class="mt-3 mb-3">
                    <div class="dl_social d-flex align-items-center">
                        <?php
                        if ( $social_icons !='' ) {
                            foreach ( $social_icons as $item ) {
                                $social_icon = !empty($item['social_icon']) ? $item['social_icon'] : '';
                                $icon_url = !empty($item['social_icon_url']) ? $item['social_icon_url'] : '';
                                ?>
                                <a href="<?php echo esc_url($icon_url) ?>" class="__icons">
                                    <i class="<?php echo esc_attr($social_icon) ?>"></i>
                                </a>
                                <?php
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
        wp_reset_postdata();
        ?>
    </div>
    <div class="template-pagination pg-style-2 mt-5">
	    <?php
	    $big = 999999999; // need an unlikely integer
	    echo paginate_links(array(
		    'base'      => str_replace($big, '%#%', get_pagenum_link($big)),
		    'format'    => '?paged=%#%',
		    'current'   => max(1, get_query_var('paged')),
		    'total'     => $dealer_lists->max_num_pages,
		    'type'      => 'list',
		    'prev_text'          => __('<i class="fa-solid fa-angles-left"></i>'),
		    'next_text'          => __('<i class="fa-solid fa-angles-right"></i>'),
	    ));
	    ?>
    </div>
</div>

