<section class="apps-section autohive_sec apps-content-wrapper">
    <div class="row">
        <div class="col-xxl-5 col-xl-6">
            <div class="apps-left">
                <?php
                if ( !empty($title) ) { ?>
                    <h2 class="h1 mb-3"><?php echo esc_html($title) ?></h2>
                    <?php
                }
                if ( !empty($subtitle) ) { ?>
                    <p class="mb-0"><?php echo esc_html($subtitle) ?></p>
                    <?php
                }
                if ( is_array($buttons) ) { ?>
                    <div class="apps-btn-group mt-40 d-flex align-items-center flex-wrap">
                        <?php
                        $i = 0;
                        foreach ( $buttons as $button ) {
                            $align_class = $i % 2 ? 'white-btn' : 'primary-btn';
                            ?>
                            <a <?php Autohive_Core_Helper::the_button($button['btn_url']) ?> class="app-btn <?php echo esc_attr($align_class) ?> d-inline-flex align-items-center">
                                <?php if ( !empty($button['icon']) ) : ?>
                                    <span class="icon-wrapper me-2">
                                        <?php \Elementor\Icons_Manager::render_icon( $button['icon'] ); ?>
                                    </span>
                                <?php endif; ?>
                                <div class="app-btn-content">
                                    <span><?php echo esc_html($button['btn_label_top']) ?></span>
                                    <strong><?php echo esc_html($button['btn_label']) ?></strong>
                                </div>
                            </a>
                            <?php
                            ++$i;
                        }
                        ?>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
        <div class="col-xxl-7 col-xl-6 align-self-end">
            <div class="apps-right position-relative z-1 mt-60 mt-xl-0">
                <button class="bg-white wallet-btn shadow rounded-circle text-primary position-absolute"><i class="fa-solid fa-wallet"></i></button>
                <button class="bg-white heart-btn shadow rounded-circle text-primary position-absolute"><i class="fa-solid fa-heart"></i></button>
                <?php
                if ( !empty($shape['id'])) { ?>
                    <div class="download-countdown position-absolute p-0">
                        <?php echo wp_get_attachment_image($shape['id'], 'full', '', array( 'class' => 'img-fluid' )); ?>
                    </div>
                    <?php
                }
                if ( !empty($fimage['id'])) {
                    echo wp_get_attachment_image($fimage['id'], 'full', '', array( 'class' => 'img-fluid' ));
                }
                ?>
            </div>
        </div>
    </div>
</section>