<section class="blog-section autohive_sec">
    <div class="row g-4">
        <?php
        while ($blog_posts->have_posts()) : $blog_posts->the_post();
            ?>
            <div class="col-xl-4 col-lg-6 col-sm-10 col-md-6">
                <article class="blog-card bg-white rounded">
                    <figure class="feature-img position-relative overflow-hidden rounded-top mb-3">
                        <a href="<?php the_permalink(); ?>">
                            <?php the_post_thumbnail('autohive_500x250', array( 'class' => 'img-fluid' )); ?>
                        </a>
                    </figure>
                    <a href="<?php echo Autohive_Core_Helper::get_the_first_category_link() ?>" class="small-btn-meta text-primary bg-primary-light">
                        <?php echo Autohive_Core_Helper::get_the_first_category() ?>
                    </a>
                    <a href="<?php the_permalink(); ?>">
                        <h5 class="mt-3 mb-3 blog-title __title"><?php echo Autohive_Core_Helper::get_the_title_length($settings,'title_length') ?></h5>
                    </a>
                    <p class="__content"><?php echo Autohive_Core_Helper::get_the_excerpt_length($settings,'excerpt_length') ?></p>
                    <div class="blog-card-bottom mt-4 d-flex align-items-center justify-content-between flex-wrap">
                        <div class="blog-card-author d-inline-flex align-items-center">
                            <?php echo Autohive_Core_Helper::get_the_author_avatar( 'user_name', 48, array( 'class' => 'flex-shrink-0 rounded-circle' )) ?>
                            <div class="blog-card-author-details ms-3">
                                <strong class="fw-bold text-secondary d-block"><?php echo get_the_author_meta('display_name') ?></strong>
                                <span class="date"><?php the_time(get_option('date_format')); ?></span>
                            </div>
                        </div>
                        <a href="<?php the_permalink(); ?>" class="blog-explore-btn d-flex align-items-center justify-content-center rounded-circle"><i class="fa-solid fa-arrow-right-long"></i></a>
                    </div>
                </article>
            </div>
            <?php
        endwhile;
        wp_reset_postdata();
        ?>
    </div>
</section>