<div class="dl2-search-car mt-5 position-relative z-1">

    <?php
    echo !empty($shape1['id']) ? wp_get_attachment_image($shape1['id'], 'full', '', [ 'class' => 'position-absolute border-left-linear z--1' ]) : '';
    echo !empty($shape2['id']) ? wp_get_attachment_image($shape2['id'], 'full', '', [ 'class' => 'position-absolute border-right-linear z--1' ]) : '';
    ?>
    <ul class="nav nav-tabs border-0" role="tablist">

        <?php
        if ( !empty($add_tab && is_array($add_tab)) ) {
            foreach ( $add_tab as $key => $tab ) {
                $active = $key + 1 ? 'active' : '';
                $aria_selected = $key + 1 ? 'true' : 'false';
                ?>
                <li>
                    <a href="#search_field" class="<?php echo esc_attr($active) ?>" data-bs-toggle="tab" aria-selected="<?php echo esc_attr($aria_selected) ?>" role="tab">All</a>
                </li>
                <?php
            }
        }
        ?>
	</ul>


    <div class="tab-content mt-3">

		<div class="tab-pane fade show active" id="search_field">
			<form action="<?php echo esc_url(htmlspecialchars($action_url)) ?>" class="dl2-search-form bg-white rounded pt-20 pb-20 px-4 d-flex align-items-center flex-wrap flex-sm-nowrap" data-formtype="all">

                <select class="form-select" name="brand" id="select_brand">
					<option selected>Select Brand</option>
                    <?php
                    $brands = get_terms(array(
	                    'taxonomy' => 'autohive_listing_brand',
	                    'hide_empty' => true
                    ));

                    if ( !empty($brands) && is_array($brands) ) {
                        foreach ( $brands as $brand ) {
                            echo '<option value="'.esc_attr($brand->slug).'">'.esc_html($brand->name).'</option>';
                        }
                    }
                    ?>
				</select>

                <select class="form-select" name="car_body_type" id="body_type">
                    <option selected>Select Body</option>
                </select>

                <select class="form-select" name="car_model" id="select_model">
					<option selected>Select Model</option>
				</select>

                <select class="form-select" name="car_transmissions" id="car_transmissions">
					<option class="">Transmission</option>
				</select>

                <button type="submit" class="submit-btn"><i class="fa-solid fa-magnifying-glass"></i></button>

			</form>
		</div>

	</div>
</div>