<div class="pickup-form-wrapper position-relative z-1">
    <form class="pickup-form bg-white rounded-1" action="<?php echo esc_url($rent_inventory_url['url']) ?>">
        <h5 class="mb-3"><?php echo esc_html($pickup_label) ?></h5>
        <select class="form-select" name="pickup" id="pickup_location" required>
            <option value="">Select Option</option>
            <?php
            $args = array(
                'post_type'     => 'autohive_rent',
                'posts_per_page' => -1,
                'orderby'       => 'meta_value',
            );
            $postslist = get_posts($args);
            if (is_array($postslist) && count($postslist) > 0) {
                $pickupLocation = array();
                foreach ($postslist as $key => $item) {
                    $pick_location = get_post_meta($item->ID, 'pickup_location', true);
                    if ($pick_location != '') {
                        foreach ($pick_location as $pickupL) {
                            $pickupLocation[] = $pickupL;
                        }
                    }
                }
            }

            $options = array_unique($pickupLocation);
            if (is_array($options)) {
                foreach ($options as $option) {
                    echo '<option value="' . $option . '">' . esc_html($option) . '</option>';
                }
            } ?>
        </select>

        <div class="checkbox-field mt-2">
            <input type="checkbox" id="pickup-checkbox">
            <label for="pickup-checkbox" class="ms-2">Return the same Location</label>
        </div>
        <div class="date-field mt-20 position-relative">
            <input type="date" class="border w-100 rounded theme-date-input" placeholder="08/09/2022" name="pick-time" required>
        </div>
        <div class="return-field mt-30">
            <h5 class="mb-3"><?php echo esc_html($return_label) ?></h5>
            <select class="form-select return-location" name="return-location" id="return_location" required>
                <option value="">Select Option</option>
                <?php
                if (is_array($postslist) && count($postslist) > 0) {
                    $pickupLocation = array();
                    foreach ($postslist as $key => $item) {
                        $pick_location = get_post_meta($item->ID, 'pickup_location', true);
                        if ($pick_location != '') {
                            foreach ($pick_location as $pickupL) {
                                $pickupLocation[] = $pickupL;
                            }
                        }
                    }
                }

                $options = array_unique($pickupLocation);
                if (is_array($options)) {
                    foreach ($options as $option) {
                        echo '<option value="' . $option . '">' . esc_html($option) . '</option>';
                    }
                }
                ?>
            </select>
            <div class="date-field mt-20 position-relative">
                <input type="date" class="border w-100 rounded theme-date-input" placeholder="08/09/2022" name="return-time" required>
            </div>
        </div>
        <button type="submit" class="btn btn-secondary mt-5"><?php echo esc_html($button_label) ?><span class="ms-2"><i class="fa-solid fa-arrow-right"></i></span></button>
    </form>
    <?php 
    echo !empty( $settings['shape1']['id']) ? wp_get_attachment_image($settings['shape1']['id'], 'full', '', [ 'class' => 'position-absolute z--1 tire-shape' ]) : '';
    echo !empty( $settings['shape2']['id']) ? wp_get_attachment_image($settings['shape2']['id'], 'full', '', [ 'class' => 'position-absolute dot-shape z--1' ]) : '';
    ?>
</div>