<div class="at-search-box">
    <div class="row">
        <div class="col-lg-12">
            <div class="at-search-box-filter bg-white">
                <ul class="nav nav-tabs border-0 justify-content-center justify-content-sm-start">
                    <?php
                    if (!empty($add_tab) && is_array($add_tab)) {
                        foreach ($add_tab as $key => $tab) {
                            $active = $key == 1 ? 'active' : '';
                            echo '<li><a href="#search_field" data-bs-toggle="tab" class="advance_search_tab ' . esc_attr($active) . '">' . esc_html($tab) . '</a></li>';
                        }
                    }
                    ?>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="search_field">
                        <form action="<?php echo esc_url(htmlspecialchars($action_url)) ?>" class="at-search-filter d-flex align-items-center" data-formtype="all">
                            <div class="input-field">
                                <label>Brand Name</label>
                                <select class="form-select" name="brand" id="select_brand">
                                    <option value="">Select Option</option>
                                    <?php
                                    $brands = get_terms(array(
                                        'taxonomy' => 'autohive_listing_brand',
                                        'hide_empty' => true
                                    ));
                                    if (!empty($brands) && is_array($brands)) {
                                        foreach ($brands as $brand) {
                                            echo '<option value="' . esc_attr($brand->slug) . '">' . esc_html($brand->name) . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="input-field">
                                <label>Select Type</label>
                                <select class="form-select" name="car_body_type" id="body_type">
                                    <option value="">Select Option</option>
                                </select>
                            </div>
                            <div class="input-field">
                                <label>Select Models</label>
                                <select class="form-select" name="car_model" id="select_model">
                                    <option value="">Select Option</option>
                                </select>
                            </div>
                            <div class="input-field">
                                <label>Transmission</label>
                                <select class="form-select" name="car_transmissions" id="car_transmissions">
                                    <option value="">Select Option</option>
                                </select>
                            </div>
                            <div class="submit-btn align-self-end">
                                <button class="btn btn-secondary btn-md" type="submit">Search Now</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>