<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Video extends Widget_Base {

	public function get_name() {
		return 'autohive_video';
	}

	public function get_title() {
		return esc_html__( 'Autohive Video', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-youtube';
	}

	public function get_style_depends() {
		return [ 'magnific-popup' ];
	}
	
	public function get_script_depends() {
		return [ 'magnific-popup' ];
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Video', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//==================== Video ==========================//
		$this->start_controls_section(
			'sec_videos', [
				'label' => __( 'Videos', 'autohive-core' ),
			]
		);

		$this->add_control(
			'video_url', [
				'label'   => esc_html__( 'Video URL', 'autohive-core' ),
				'type'    => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '#',
			]
		);

		$this->add_control(
			'video_icon', [
				'label' => esc_html__( 'Icon', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-play',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_responsive_control(
			'alignment', [
				'label' => esc_html__( 'Alignment', 'autohive-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'autohive-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'autohive-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'autohive-core' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .video-content' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section(); //End Video

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );

		//=============== Template Parts ================//
		require __DIR__ . '/templates/video/layout-'.$layout.'.php';

	}


}