<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Testimonials extends Widget_Base {

	public function get_name() {
		return 'autohive_testimonials';
	}

	public function get_title() {
		return esc_html__( 'Autohive Testimonial', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_style_depends() {
		return ['swiper'];
	}

	public function get_script_depends() {
		return ['swiper'];
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Testimonials', 'autohive-core' ),
					'2' => esc_html__( '02: Testimonials', 'autohive-core' ),
					'3' => esc_html__( '03: Testimonials', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//=============================== Start Testimonials ========================//
		$this->start_controls_section(
			'sec_testimonials', [
				'label' => esc_html__( 'Testimonials', 'autohive-core' ),
			]
		);

		//========= Layout 01, 02
		$testimonial = new \Elementor\Repeater();
		$testimonial->add_control(
			'author_img', [
				'label' => esc_html__( 'Author Image', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);

		$testimonial->add_control(
			'name', [
				'label' => esc_html__( 'Author Name', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Chris Hoang Siama',
			]
		);

		$testimonial->add_control(
			'designation', [
				'label' => esc_html__( 'Designation', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Chris Hoang Siama',
			]
		);

		$testimonial->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'Amazing Support!',
			]
		);

		$testimonial->add_control(
			'contents', [
				'label' => esc_html__( 'Review Contents', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
			]
		);

		$testimonial->add_control(
			'ratting_num', [
				'label' => esc_html__( 'Ratting Number', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '4.5',
			]
		);

		$this->add_control(
			'testimonials', [
				'label' => esc_html__( 'Add Testimonials', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $testimonial->get_controls(),
				'title_field' => '{{{ name }}}',
				'condition' => [
					'layout' => [ '1', '2' ]
				]
			]
		); // End Layout 01, 02

		//========= Layout 03
		$testimonial3 = new \Elementor\Repeater();
		$testimonial3->add_control(
			'author_img', [
				'label' => esc_html__( 'Author Image', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);

		$testimonial3->add_control(
			'name', [
				'label' => esc_html__( 'Author Name', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Charles Larocque',
			]
		);

		$testimonial3->add_control(
			'designation', [
				'label' => esc_html__( 'Designation', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Managing Director',
			]
		);

		$testimonial3->add_control(
			'contents', [
				'label' => esc_html__( 'Review Contents', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
			]
		);

		$testimonial3->add_control(
			'rating', [
				'label' => __('Rating', 'landpagy-core'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => autohive_el_ratting_options(),
				'default' => '5'
			]
		);

		$this->add_control(
			'testimonials3', [
				'label' => esc_html__( 'Add Testimonials', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $testimonial3->get_controls(),
				'title_field' => '{{{ name }}}',
				'condition' => [
					'layout' => [ '3' ]
				]
			]
		); // End Layout 03

		$this->add_control(
			'quote_image', [
				'label' => esc_html__( 'Quote Image', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'layout' => [ '1', '2'  ]
				]
			]
		);

		$this->end_controls_section(); //End Testimonials


		//==================== Carousel Settings ===================//
		$this->start_controls_section(
			'carousel_settings',
			[
				'label' => __('Carousel Settings', 'autohive-core'),

			]
		);
		$this->add_control(
			'show_items_desktop',
			[
				'label'     => esc_html__('Display Items [Desktop]', 'autohive-core'),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 1
			]
		);
		$this->add_control(
			'show_items_tablet',
			[
				'label'     => esc_html__('Display Items [Tablet]', 'autohive-core'),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 1
			]
		);
		$this->add_control(
			'show_items_mobile',
			[
				'label'     => esc_html__('Display Items [Mobile]', 'autohive-core'),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 1
			]
		);
		$this->add_control(
			'item_space',
			[
				'label' => __('Item Space', 'autohive-core'),
				'type' => Controls_Manager::SLIDER,

				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'default' => [
					'size' => 24,
				]
			]
		);
		$this->add_control(
			'carousel_autoplay',
			[
				'label' => __('Auto Play', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('True', 'autohive-core'),
				'label_off' => __('False',
					'autohive-core'
				),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'carousel_loop',
			[
				'label' => __('Loop',
					'autohive-core'
				),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('True', 'autohive-core'),
				'label_off' => __('False',
					'autohive-core'
				),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'slide_speed',
			[
				'label' => esc_html__('Slide Speed', 'autohive-core'),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5000,
				'step' => 1,
				'default' => 500
			]
		);
		$this->end_controls_section();

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

		$this->start_controls_section(
			'style_testimonials', [
				'label' => esc_html__( 'Testimonials', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		//============= Item Title Color
		$this->add_control(
			'item_title_option', [
				'label' => esc_html__( 'Title Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'layout' => '1'
				]
			]
		);

		$this->add_control(
			'title_color', [
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title' => 'color: {{VALUE}}',
				],
				'condition' => [
					'layout' => '1'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'title_typo',
				'selector' => '{{WRAPPER}} .__title',
				'condition' => [
					'layout' => '1'
				]
			]
		); //End Item Title Color


		//============= Review Content Color
		$this->add_control(
			'item_content_option', [
				'label' => esc_html__( 'Content Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'content_color', [
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__content' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'content_typo',
				'selector' => '{{WRAPPER}} .__content',
			]
		); //End Review Content Color


		//============= Author Name Color
		$this->add_control(
			'author_name_option', [
				'label' => esc_html__( 'Author Name Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'author_name_color', [
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__name' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'author_name_typo',
				'selector' => '{{WRAPPER}} .__name',
			]
		); //End Author Name Color


		//============= Author Designation Color
		$this->add_control(
			'designation_option', [
				'label' => esc_html__( 'Designation Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'designation_color', [
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__designation' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'designation_typo',
				'selector' => '{{WRAPPER}} .__designation',
			]
		); //End Author Designation Color

		$this->end_controls_section(); //End Testimonials Style

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );

		//=============== Template Parts ================//
		require __DIR__ . '/templates/testimonials/testimonial-'.$layout.'.php';

	}


}