<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Border,
	Group_Control_Box_Shadow,
	Group_Control_Text_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Subscriber extends Widget_Base {

	public function get_name() {
		return 'autohive_subscriber';
	}

	public function get_title() {
		return esc_html__( 'Autohive Subscriber', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-mailchimp';
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( 'Layout 01', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//========================= Mailchimp ========================//
		$this->start_controls_section( 'subscriber_sec', [
			'label' => __( 'Newsletter', 'autohive-core' ),
		] );

		$this->add_control( 'email_placeholder', [
			'label'       => esc_html__( 'Email Placeholder', 'autohive-core' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => __( 'Enter your email', 'autohive-core' ),
			'label_block' => true,
		] );

		$this->add_control( 'submit_btn', [
			'label'       => esc_html__( 'Button Text', 'autohive-core' ),
			'type'        => Controls_Manager::TEXT,
			'label_block' => true,
			'default'     => __( 'SUBSCRIBE', 'autohive-core' ),
			'separator'   => 'before',
		] );

		$this->end_controls_section(); //End Mailchimp

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {



		$this->start_controls_section(
			'style_form_btn', [
				'label' => esc_html__( 'Form Button', 'autohive-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name' => 'form_btn_typo',
				'selector' => '{{WRAPPER}} .__btn',
			]
		);

		//=== Button Tabs : Normal & Hover
		$this->start_controls_tabs( 'tabs_button_style' );

		// Button Normal
		$this->start_controls_tab(
			'tab_button_normal', [
				'label' => esc_html__( 'Normal', 'autohive-core' ),
			]
		);

		$this->add_control(
			'form_btn_text_color', [
				'label' => esc_html__( 'Text Color', 'autohive-core' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .__btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(), [
				'name' => 'form_btn_background',
				'label' => esc_html__( 'Background', 'autohive-core' ),
				'types' => [ 'classic', 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .__btn',
				'fields_options' => [
					'background' => [
						'default' => 'classic',
					],
				],
			]
		);

		$this->end_controls_tab(); //End Button Normal

		// Button Hover
		$this->start_controls_tab(
			'tab_button_hover', [
				'label' => esc_html__( 'Hover', 'autohive-core' ),
			]
		);

		$this->add_control(
			'form_btn_hover_color', [
				'label' => esc_html__( 'Text Color', 'autohive-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__btn:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(), [
				'name' => 'form_btn_background_hover',
				'label' => esc_html__( 'Background', 'autohive-core' ),
				'types' => [ 'classic', 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .__btn:hover',
				'fields_options' => [
					'background' => [
						'default' => 'classic',
					],
				],
			]
		);

		$this->end_controls_tab(); // End Button Hover

		$this->end_controls_tabs(); // End Button Tabs

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name' => 'form_btn_border',
				'selector' => '{{WRAPPER}} .__btn',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'form_btn_border_radius', [
				'label' => esc_html__( 'Border Radius', 'autohive-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .__btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'form_btn_text_padding', [
				'label' => esc_html__( 'Padding', 'autohive-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .__btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();




	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );

		//=============== Template Parts ================//`
		require __DIR__ . '/templates/subscriber/layout-'.$layout.'.php';

	}


}