<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_slider extends Widget_Base {

	public function get_name() {
		return 'autohive-slider';
	}

	public function get_title() {
		return esc_html__( 'Autohive Slider', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	public function get_style_depends() {
		return [ 'swiper' ];
	}

	public function get_script_depends() {
		return [ 'swiper' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}

	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {

		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Slider Fullwidth', 'autohive-core' ),
					'2' => esc_html__( '02: Slider Box', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//===================== Slider Section =====================//
		$this->start_controls_section( 'slider_controls_section', [
			'label' => esc_html__( 'Slider', 'autohive-core' ),
		] );

		//Slider 01
		$repeater = new Repeater();
		$repeater->add_control( 'slide_title', [
			'label'       => __( 'Title', 'autohive-core' ),
			'type'        => Controls_Manager::TEXTAREA,
			'default'     => __( 'Virtual Private Servers', 'autohive-core' )
		] );

		$repeater->add_control( 'slide_subtitle', [
			'label'       => __( 'Sub Title', 'autohive-core' ),
			'type'        => Controls_Manager::TEXTAREA,
			'default'     => __( 'Managed VPS Hosting', 'autohive-core' ),
		] );

		$repeater->add_control( 'slide_desc', [
			'label'       => __( 'Short Description', 'autohive-core' ),
			'type'        => Controls_Manager::TEXTAREA,
			'description' => esc_html__( 'Use <mark> tag for colored text', 'autohive-core' ),
			'default'     => __( 'VPS Starter plan - Starting <mark>at $10.00/mo</mark>', 'autohive-core' ),
		] );

		$repeater->add_control( 'feature_list', [
			'label'       => __( 'Features', 'autohive-core' ),
			'type'        => Controls_Manager::TEXTAREA,
			'description' => esc_html__( 'Every feature item should be a new line', 'autohive-core' ),
			'default'     => __( 'Managed Performance, Security, & Updates
                Unhindered performance with your own server resources
                Expandable RAM & storage', 'autohive-core' ),
		] );

		$repeater->add_control( 'btn_label', [
			'label'       => __( 'Button Label', 'autohive-core' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => __( 'Buy VPS Hosting', 'autohive-core' )
		] );

		$repeater->add_control( 'btn_url', [
			'label'       => __( 'Button URL', 'autohive-core' ),
			'type'        => Controls_Manager::URL,
			'default'     => [
				'url'   => '#'
			]
		] );

		$repeater->add_control( 'feature_image', [
			'label'   => __( 'Feature Image', 'autohive-core' ),
			'type'    => Controls_Manager::MEDIA,
			'default' => [
				'url' => plugin_dir_url(__DIR__) . '/assets/images/slider/hero-car-1.png',
			]
		] );
		$repeater->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'slider_background',
				'label' => __( 'Background', 'autohive-core' ),
				'types' => [ 'classic', 'gradient', 'video'],
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
			]
		);

		$this->add_control( 'autohive_slides', [
			'label'       => __( 'Slider Items', 'autohive-core' ),
			'type'        => Controls_Manager::REPEATER,
			'fields'      => $repeater->get_controls(),
			'title_field' => '{{{ slide_title }}}',
			'condition' => [
				'layout' => '1'
			]
		] ); //End Slider 01


		//=========== Slider 02
		$slider2 = new Repeater();
		$slider2->add_control( 'title', [
			'label'       => __( 'Title', 'autohive-core' ),
			'type'        => Controls_Manager::TEXTAREA,
			'default'     => __( 'Original Equipment <br> Manufacturer', 'autohive-core' ),
		] );

		$slider2->add_control( 'subtitle', [
			'label'       => __( 'Subtitle', 'autohive-core' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => __( 'We Are Manufacturer', 'autohive-core' )
		] );

		$slider2->add_control( 'contents', [
			'label'       => __( 'Contents', 'autohive-core' ),
			'type'        => Controls_Manager::TEXTAREA,
		] );


		$slider2->add_control( 'btn_label', [
			'label'       => __( 'Button Label', 'autohive-core' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => __( 'Discover More', 'autohive-core' )
		] );

		$slider2->add_control( 'btn_url', [
			'label'       => __( 'Button URL', 'autohive-core' ),
			'type'        => Controls_Manager::URL,
			'default'     => [
				'url'   => '#'
			]
		] );

		$slider2->add_group_control(
			Group_Control_Background::get_type(), [
				'name' => 'slider_background',
				'label' => __( 'Background', 'autohive-core' ),
				'types' => [ 'classic', 'gradient', 'video'],
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
			]
		);

		$this->add_control( 'sliders2', [
			'label'       => __( 'Slider Items', 'autohive-core' ),
			'type'        => Controls_Manager::REPEATER,
			'fields'      => $slider2->get_controls(),
			'title_field' => '{{{ title }}}',
			'condition' => [
				'layout' => '2'
			],
		] ); //End Slider 02

		$this->end_controls_section();




		/* Carousel Settings =================== */
		$this->start_controls_section(
			'carousel_settings', [
				'label' => __( 'Carousel Settings', 'autohive-core' ),
			]
		);

		$this->add_control(
			'carousel_autoplay',
			[
				'label' => __( 'Auto Play', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'True', 'autohive-core' ),
				'label_off' => __( 'False', 'autohive-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'carousel_loop',
			[
				'label' => __( 'Loop', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'True', 'autohive-core' ),
				'label_off' => __( 'False', 'autohive-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'slide_speed', [
				'label' => esc_html__( 'Slide Speed', 'autohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5000,
				'step' => 1,
				'default' => 1000
			]
		);
		$this->end_controls_section();


		//==================== Follow on icon Settings =================== //
		$this->start_controls_section(
			'follow_us_sec', [
				'label' => __( 'Follow on', 'autohive-core' ),
				'condition' => [
					'layout' => '1'
				]
			]
		);
		$this->add_control(
			'is_social_icons',
			[
				'label' => __( 'Social Icon Show/Hide', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'True', 'autohive-core' ),
				'label_off' => __( 'False', 'autohive-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 'follow_on_text', [
			'label'       => __( 'Follow on text', 'autohive-core' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => __( 'Follow on', 'autohive-core' ),
			'separator' => 'after'
		] );


		//======== Repeater Icons
		$social_icons = new \Elementor\Repeater();
		$social_icons->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-facebook-f',
					'library' => 'fa-brands',
				],
			]
		);

		$social_icons->add_control(
			'icon_url', [
				'label' => esc_html__( 'Text', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'default' => [
					'url' => '#'
				]
			]
		);

		$this->add_control(
			'social_icons', [
				'label' => esc_html__( 'Add Social Icon', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $social_icons->get_controls(),
				'title_field' => '{{{ icon.value }}}',
				'prevent_empty' => false
			]
		);


		$this->end_controls_section(); //End Follow on icon Settings


		//==================== Scroll Down Settings =================== */
		$this->start_controls_section(
			'scroll_down_sec', [
				'label' => __( 'Scroll Down', 'autohive-core' ),
				'condition' => [
					'layout' => '1'
				]
			]
		);
		$this->add_control(
			'is_scroll_down',[
				'label' => __( 'Scroll Down Icon Show/Hide', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'True', 'autohive-core' ),
				'label_off' => __( 'False', 'autohive-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 'scroll_down_label', [
			'label'       => __( 'Scroll Down text', 'autohive-core' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => __( 'Scroll Down', 'autohive-core' )
		] );

		$this->add_control( 'scroll_down_sec_id', [
			'label'       => __( 'Scroll Down Section ID', 'autohive-core' ),
			'type'        => Controls_Manager::TEXT,
			'placeholder' => '#section_id',
			'default'     => ''
		] );

		$this->end_controls_section(); // End Scroll Down Settings

    }


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {


		// Style Section Background ================================
		$this->start_controls_section( 'slider_style_section', [
			'label' => __( 'Section Background', 'autohive-core' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		] );

		$this->add_control(
			'slider_margin',
			[
				'label' => __( 'Margin', 'autohive-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .dealership-hero' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);
		$this->add_control(
			'slider_padding',
			[
				'label' => __( 'Padding', 'autohive-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .dealership-hero' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'section_background',
				'label' => __( 'Background', 'autohive-core' ),
				'types' => [ 'classic', 'gradient'],				
				'selector' => '{{WRAPPER}} .dealership-hero',
			]
		);

		$this->end_controls_section();
	}



	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );


		//=============== Template Parts ================//
		require __DIR__ . '/templates/hero-slider/hero-slider-'.$layout.'.php';

	}


}