<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Services extends Widget_Base {

	public function get_name() {
		return 'autohive_services';
	}

	public function get_title() {
		return esc_html__( 'Autohive Service', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_style_depends() {

		if ( \Elementor\Plugin::$instance->preview->is_preview_mode()) {
			return [];
		} else {
			$settings = $this->get_settings_for_display();
			if ( $settings['layout'] == '2' ) {
				return ['swiper'];
			}
			return [];
		}
	}

	public function get_script_depends() {
		if ( \Elementor\Plugin::$instance->preview->is_preview_mode()) {
			return [];
		} else {
			$settings = $this->get_settings_for_display();
			if ( $settings['layout'] == '2' ) {
				return ['swiper'];
			}
			return [];
		}
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Service Grid', 'autohive-core' ),
					'2' => esc_html__( '02: Service Grid', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//======================== Filter Options ==========================//
		$this->start_controls_section(
			'filter', [
				'label' => __( 'Filter', 'autohive-core' ),
			]
		);

		$this->add_control(
			'show_count', [
				'label' => esc_html__( 'Show Posts Count', 'autohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 4
			]
		);

		$this->add_control(
			'cats', [
				'label' => esc_html__( 'Category', 'autohive-core' ),
				'type'      => Controls_Manager::SELECT2,
				'options'   => \Autohive_Core_Helper::get_the_category_array('service_cat'),
				'label_block' => true,
				'multiple'  => true,
			]
		);

		$this->add_control(
			'order', [
				'label' => esc_html__( 'Order', 'autohive-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'ASC' => 'ASC',
					'DESC' => 'DESC'
				],
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'orderby', [
				'label' => esc_html__( 'Order By', 'autohive-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => 'None',
					'ID' => 'ID',
					'author' => 'Author',
					'title' => 'Title',
					'name' => 'Name (by post slug)',
					'date' => 'Date',
					'rand' => 'Random',
				],
				'default' => 'none'
			]
		);

		$this->add_control(
			'title_length', [
				'label' => esc_html__('Title Length', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::NUMBER,
			]
		);

		$this->add_control(
			'excerpt_length', [
				'label' => esc_html__('Excerpt Word Length', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 15,
			]
		);

		$this->add_control(
			'exclude', [
				'label' => esc_html__( 'Exclude Post', 'autohive-core' ),
				'description' => esc_html__( 'Enter the Listting post IDs to hide/exclude. Input the multiple ID with comma separated', 'autohive-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->end_controls_section(); //End Filter's


		//============================= Buttons ============================== //
		$this->start_controls_section(
			'buttons_sec', [
				'label' => __( 'Buttons', 'autohive-core' ),
			]
		);

		$this->add_control(
			'read_more_btn', [
				'label' => esc_html__( 'Read More Button', 'autohive-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__('Explore More', 'autohive-core')
			]
		);

		$this->end_controls_section(); //Buttons
		

		//==================== Slider Control Settings ===================//
		$this->start_controls_section(
			'slider_control_sec', [
				'label' => __('Slider Settings', 'autohive-core'),
				'condition' => [
					'layout' => '2'
				]
			]
		);
		$this->add_control(
			'show_items_desktop', [
				'label'     => esc_html__('Display Items [Desktop]', 'autohive-core'),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 3
			]
		);
		$this->add_control(
			'show_items_tablet', [
				'label'     => esc_html__('Display Items [Tablet]', 'autohive-core'),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 2
			]
		);
		$this->add_control(
			'show_items_mobile', [
				'label'     => esc_html__('Display Items [Mobile]', 'autohive-core'),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 1
			]
		);
		$this->add_control(
			'item_space', [
				'label' => __('Item Space', 'autohive-core'),
				'type' => Controls_Manager::SLIDER,

				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'default' => [
					'size' => 24,
				]
			]
		);
		$this->add_control(
			'carousel_autoplay', [
				'label' => __('Auto Play', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('True', 'autohive-core'),
				'label_off' => __('False',
					'autohive-core'
				),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'carousel_loop', [
				'label' => __('Loop',
					'autohive-core'
				),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('True', 'autohive-core'),
				'label_off' => __('False',
					'autohive-core'
				),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'slide_speed', [
				'label' => esc_html__('Slide Speed', 'autohive-core'),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5000,
				'step' => 1,
				'default' => 500
			]
		);
		$this->end_controls_section(); //End Slider Controls

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

		//============================= Contents Style ============================== //
		$this->start_controls_section(
			'item_content_style', [
				'label' => __( 'Item Contents', 'autohive-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		// Title Options
		$this->add_control(
			'item_title_options', [
				'label' => esc_html__( 'Title Options', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'item_title_typo',
				'selector' => '{{WRAPPER}} .__title',
			]
		);

		$this->add_control(
			'item_title_color', [
				'label' => esc_html__( 'Text Color', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'item_title_hover_color', [
				'label' => esc_html__( 'Text Color', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title:hover' => 'color: {{VALUE}}',
				],
			]
		);

		// Sub-Title Options
		$this->add_control(
			'item_content_options', [
				'label' => esc_html__( 'Content Options', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'item_content_typo',
				'selector' => '{{WRAPPER}} .__content',
			]
		);

		$this->add_control(
			'item_content_color', [
				'label' => esc_html__( 'Text Color', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__content' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section(); // End Contents


		//============================= Section Background ============================== //
		$this->start_controls_section(
			'sec_bg_style', [
				'label' => __( 'Section Background', 'autohive-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'sec_margin', [
				'label' => __( 'Margin', 'autohive-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .__autohive_sec' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'sec_padding', [
				'label' => __( 'Padding', 'autohive-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .__autohive_sec' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(), [
				'name' => 'sec_background',
				'label' => __( 'Background', 'autohive-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .__autohive_sec',
			]
		);

		$this->end_controls_section(); //End Section Background

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );


		$args = [
			'post_type' => 'service',
			'post_status' => 'publish',
		];

		if ( !empty($show_count) ) {
			$args['posts_per_page'] = $show_count;
		}

		if ( !empty($order) ) {
			$args['order'] = $order;
		}

		if ( !empty($orderby) ) {
			$args['orderby'] = $orderby;
		}

		if ( !empty($exclude ) ) {
			$args['post__not_in'] = $exclude;
		}

		if ( !empty($cats && $cats != '') ) {
			$args['tax_query'] = [
				[
					'taxonomy'  => 'service_cat',
					'field'     => 'slug',
					'terms'     => $cats,
				]
			];
		}

		$service_posts = new \WP_Query( $args );


		//=============== Template Parts ================//
		require __DIR__ . '/templates/service/service-'.$layout.'.php';

	}


}