<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Promo_Slider extends Widget_Base {

	public function get_name() {
		return 'autohive_promo_slider';
	}

	public function get_title() {
		return esc_html__( 'Autohive Promo Slider', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_style_depends() {
		return ['swiper'];
	}

	public function get_script_depends() {
		return ['swiper'];
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {

		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Carousel Slider', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//======================= Promo Slider ==========================//
		$this->start_controls_section(
			'sec_promo_slider', [
				'label' => esc_html__( 'Promo Slider', 'autohive-core' ),
			]
		);

		$slider = new \Elementor\Repeater();
		$slider->add_control(
			'align_items', [
				'type' => \Elementor\Controls_Manager::HIDDEN,
			]
		);

		$slider->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);

		$slider->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'default' => [
					'url' => '#'
				],
			]
		);

		$this->add_control(
			'sliders', [
				'label' => esc_html__( 'Add Slider', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $slider->get_controls(),
				'title_field' => '{{{ align_items }}}',
			]
		);

		$this->end_controls_section(); //End Promo Slider

		//==================== Carousel Settings ===================//
		$this->start_controls_section(
			'carousel_settings',
			[
				'label' => __('Carousel Settings', 'autohive-core'),
				
			]
		);
		$this->add_control(
			'show_items_desktop',
			[
				'label'     => esc_html__('Display Items [Desktop]', 'autohive-core'),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 2
			]
		);
		$this->add_control(
			'show_items_tablet',
			[
				'label'     => esc_html__('Display Items [Tablet]', 'autohive-core'),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 2
			]
		);
		$this->add_control(
			'show_items_mobile',
			[
				'label'     => esc_html__('Display Items [Mobile]', 'autohive-core'),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 1
			]
		);
		$this->add_control(
			'item_space',
			[
				'label' => __('Item Space', 'autohive-core'),
				'type' => Controls_Manager::SLIDER,
				
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'default' => [
					'size' => 24,
				]
			]
		);
		$this->add_control(
			'carousel_autoplay',
			[
				'label' => __('Auto Play', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('True', 'autohive-core'),
				'label_off' => __('False', 'autohive-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'carousel_loop',
			[
				'label' => __('Loop', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('True', 'autohive-core'),
				'label_off' => __('False', 'autohive-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'slide_speed',
			[
				'label' => esc_html__('Slide Speed', 'autohive-core'),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5000,
				'step' => 1,
				'default' => 500
			]
		);
		$this->end_controls_section();

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

	}

	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {
		$settings     = $this->get_settings_for_display();
		extract( $settings );


		// Template File Parts
		require __DIR__ . '/templates/promo-slider/layout-'.$layout.'.php';

	}


}