<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Product extends Widget_Base {

	public function get_name() {
		return 'autohive_product';
	}

	public function get_title() {
		return esc_html__( 'Autohive Product', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-products';
	}

	public function get_style_depends() {
		return ['swiper', 'autohive-shop'];
	}

	public function get_script_depends() {
		return ['swiper', 'isotop', 'autohive-shop'];
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Product Slider', 'autohive-core' ),
					'2' => esc_html__( '02: Product Category', 'autohive-core' ),
					'3' => esc_html__( '03: Product Slider', 'autohive-core' ),
					'4' => esc_html__( '04: Product Tab', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//================================ Query Filter ============================//
		$this->start_controls_section(
			'query_filter', [
				'label' => __( 'Filter', 'autohive-core' ),
				'condition' => [
					'layout' => [ '1', '2', '3' ]
				]
			]
		);

		$this->add_control(
			'all_label', [
				'label' => esc_html__( 'All filter label', 'autohive-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'All Parts',
				'condition' => [
					'layout' => '2'
				]
			]
		);

		$this->add_control(
			'cats', [
				'label' => esc_html__( 'Categories', 'autohive-core' ),
				'description' => esc_html__( 'Display portfolios by categories', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => \Autohive_Core_Helper::get_the_category_array('product_cat'),
				'label_block' => true,
				'multiple' => true,
			]
		);

		$this->add_control(
			'title_length', [
				'label' => esc_html__('Title Length', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 8
			]
		);

		$this->add_control(
			'show_count', [
				'label' => esc_html__( 'Show count', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 6
			]
		);

		$this->add_control(
			'order', [
				'label' => esc_html__( 'Order', 'autohive-core' ),
				'description' => esc_html__( '‘ASC‘ – ascending order from lowest to highest values (1, 2, 3; a, b, c). ‘DESC‘ – descending order from highest to lowest values (3, 2, 1; c, b, a).', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'ASC' => 'ASC',
					'DESC' => 'DESC'
				],
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'orderby', [
				'label' => esc_html__( 'Order By', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => 'None',
					'ID' => 'ID',
					'author' => 'Author',
					'title' => 'Title',
					'name' => 'Name (by post slug)',
					'date' => 'Date',
					'rand' => 'Random',
					'comment_count' => 'Comment Count',
				],
				'default' => 'none'
			]
		);

		$this->add_control(
			'exclude', [
				'label' => esc_html__( 'Exclude', 'autohive-core' ),
				'description' => esc_html__( 'Enter the product ID to hide. Input the multiple ID with comma separated', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'is_discount_percentage', [
				'label' => esc_html__( 'Show Discount Percentage', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'textdomain' ),
				'label_off' => esc_html__( 'Hide', 'textdomain' ),
				'return_value' => 'yes',
				'default' => 'no',
				'separator' => 'before',
				'condition' => [
					'layout' => '3'
				]
			]
		);

		$this->end_controls_section(); //End Query filter



		//================================ Query Tab Filter Layout 04 ============================//
		$this->start_controls_section(
			'query_filter2', [
				'label' => __( 'Filter', 'autohive-core' ),
				'condition' => [
					'layout' => [ '4' ]
				]
			]
		);

		$filter2 = new \Elementor\Repeater();

		$filter2->add_control(
			'tab_title', [
				'label' => esc_html__( 'Tab Title', 'autohive-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'New Arrivals'
			]
		);

		$filter2->add_control(
			'select_query', [
				'label' => esc_html__( 'Select Query', 'autohive-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'new_arrival' => esc_html__( 'New Arrivals', 'autohive-core' ),
					'featured' => esc_html__( 'Featured', 'autohive-core' ),
					'best_seller' => esc_html__( 'Best Seller', 'autohive-core' ),
					'popular'=> esc_html__( 'Popular', 'autohive-core' ),
				],
				'default' => 'new_arrival'
			]
		);

		$filter2->add_control(
			'title_length', [
				'label' => esc_html__('Title Length', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 8
			]
		);

		$filter2->add_control(
			'show_count', [
				'label' => esc_html__( 'Show count', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 6
			]
		);

		$filter2->add_control(
			'exclude', [
				'label' => esc_html__( 'Exclude', 'autohive-core' ),
				'description' => esc_html__( 'Enter the product ID to hide. Input the multiple ID with comma separated', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'product_tab', [
				'label' => esc_html__( 'Add Product Tab', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $filter2->get_controls(),
				'title_field' => '{{{ tab_title }}}',
			]
		);


		$this->end_controls_section(); //End Filter Tab 04


		//======================== Column ======================//
		$this->start_controls_section(
			'sec_column', [
				'label' => __( 'Column', 'authohive-core' ),
			]
		);

		$this->add_control(
			'column', [
				'label' => esc_html__( 'Column', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'6' => 'Two',
					'4' => 'Three',
					'3' => 'Four',
					'2' => 'Six',
				],
				'default' => '3',
				'separator' => 'before'
			]
		);

		$this->end_controls_section(); //End Column



		//======================== Slider Control ======================//
		$this->start_controls_section(
			'slider_control_settings', [
				'label' => __( 'Slider Control', 'authohive-core' ),
				'condition' => [
					'layout' => [ '1', '3' ],
				]
			]
		);

		$this->add_control(
			'show_items_desktop', [
				'label'     => esc_html__( 'Display Items [Desktop]', 'authohive-core' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 3,
			]
		);

		$this->add_control(
			'show_items_tablet', [
				'label'     => esc_html__( 'Display Items [Tablet]', 'authohive-core' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 2
			]
		);

		$this->add_control(
			'show_items_mobile', [
				'label'     => esc_html__( 'Display Items [Mobile]', 'authohive-core' ),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 1
			]
		);

		$this->add_control(
			'item_space', [
				'label' => __( 'Item Space', 'authohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 24
			]
		);

		$this->add_control(
			'item_speed', [
				'label' => __( 'Speed', 'authohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 1500
			]
		);

		$this->end_controls_section(); //End Slider Control

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

		//======================== Style Item Title ======================//
		$this->start_controls_section(
			'style_item_title', [
				'label' => __( 'Title', 'authohive-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'item_title_typo',
				'selector' => '{{WRAPPER}} .__title',
			]
		);

		$this->add_control(
			'item_title_typo', [
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {
		$settings     = $this->get_settings_for_display();
		extract( $settings );

		$args = [
			'post_type' => 'product',
			'post_status' => 'publish',
		];

		if ( !empty($show_count) ) {
			$args['posts_per_page'] = $show_count;
		}

		if ( !empty($order) ) {
			$args['order'] = $order;
		}

		if ( !empty($orderby) ) {
			$args['orderby'] = $orderby;
		}

		if ( !empty($exclude ) ) {
			$args['post__not_in'] = $exclude;
		}

		if ( !empty($cats && $cats != '') ) {
			$args['tax_query'] = [
				[
					'taxonomy'  => 'product_cat',
					'field'     => 'slug',
					'terms'     => $cats,
				]
			];
		}

		$product_query = new \WP_Query( $args );

		//=============== Template Parts ================//
		require __DIR__ . '/templates/product/product-'.$layout.'.php';

	}


}