<?php

namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Autohive_Main_Nav_Walker;
use Elementor\{Controls_Manager, Widget_Base};

class Autohive_Navbar extends Widget_Base {

	public function get_name() {
		return 'autohive_navbar';
	}

	public function get_title() {
		return esc_html__( 'Autohive Navbar', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-nav-menu';
	}

	public function get_style_depends() {
		return [ 'custom-scrollbar' ];
	}

	public function get_script_depends() {
		return [ 'custom-scrollbar' ];
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this->autohive_elementor_content_control();
		$this->autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Category Menu', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//========================= Menu Layout ==========================//
		$this->start_controls_section(
			'menu_sections', [
				'label' => __( 'Menu', 'autohive-core' ),
			]
		);

		$menus = $this->get_menus();

		if ( ! empty( $menus ) ) {
			$this->add_control(
				'autohive_menus', [
					'label'        => __( 'Select Main Menu', 'autohive-core' ),
					'type'         => Controls_Manager::SELECT,
					'options'      => $menus,
					'default'      => array_keys( $menus )[0],
					'save_default' => true,
					'separator'    => 'before',
					'description'  => sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'autohive-core' ), admin_url( 'nav-menus.php' ) ),
				]
			);

			$this->add_control(
				'autohive_vertical_menus', [
					'label'        => __( 'Select Vertical Menu', 'autohive-core' ),
					'type'         => Controls_Manager::SELECT,
					'options'      => $menus,
					'default'      => array_keys( $menus )[0],
					'save_default' => true,
					'separator'    => 'before',
					'description'  => sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'autohive-core' ), admin_url( 'nav-menus.php' ) ),
				]
			);

		} else {
			$this->add_control(
				'menus_alert', [
					'type'            => Controls_Manager::RAW_HTML,
					'raw'             => sprintf( __( '<strong>There are no menus in your site.</strong><br>Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'autohive-core' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator'       => 'after',
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}

		$this->end_controls_section();


		//========================= Compare Page URL ==========================//
		$this->start_controls_section(
			'menu_compare_page_url', [
				'label' => __( 'Compare Page', 'autohive-core' ),
			]
		);

		$this->add_control(
			'compare_page_link', [
				'label'   => esc_html__( 'Page Link', 'autohive-core' ),
				'type'    => Controls_Manager::URL,
				'default' => [
					'url' => '#'
				],
			]
		);

		$this->end_controls_section(); //End Compare Page URL

	}

	private function get_menus() {
		$menus = wp_get_nav_menus();
		if ( ! empty( $menus ) ) {
			$options = [];
			foreach ( $menus as $menu ) {
				$options[ $menu->name ] = $menu->name;
			}

			return $options;
		}
	}

	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

	}


	// Get Menus

	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();
		extract( $settings );


		$main_menu_html = wp_nav_menu( array(
			'menu'        => $autohive_menus,
			'menu_class'  => '',
			'echo'        => false,
			'fallback_cb' => '__return_empty_string',
			'container'   => '',
			'walker'      => new Autohive_Main_Nav_Walker(),
		) );

		$vertical_menu_html = wp_nav_menu( array(
			'menu'        => $autohive_vertical_menus,
			'menu_class'  => 'product_category_nav',
			'echo'        => false,
			'fallback_cb' => '__return_empty_string',
			'container'   => '',
			'walker'      => new Autohive_Main_Nav_Walker(),
		) );


		//=============== Template Parts ================//
		require __DIR__ . '/templates/navbar/navbar-' . $layout . '.php';

	}


}