<?php

namespace Autohive\Widgets;

if (!defined('ABSPATH')) {
	exit;
}

use Autohive_Core_Helper;
use Autohive_Theme_Helper;
use Elementor\{
	Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils
};

class Autohive_Listing_Rent extends Widget_Base
{

	public function get_name()
	{
		return 'autohive_listing_rent';
	}

	public function get_title()
	{
		return esc_html__('Autohive Rental', 'autohive-core');
	}

	public function get_icon()
	{
		return 'eicon-dashboard';
	}

	public function get_categories()
	{
		return ['autohive-elements'];
	}

	public function get_style_depends()
	{
		return ['swiper'];
	}

	public function get_script_depends()
	{
		return ['swiper'];
	}


	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls()
	{
		$this->autohive_elementor_content_control();
		$this->autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control()
	{


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout',
			[
				'label' => __('Layout', 'autohive-core'),
			]
		);

		$this->add_control(
			'layout',
			[
				'label'   => esc_html__('Layout', 'autohive-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'inventory' => esc_html__('Rent Inventory', 'autohive-core'),
					'slider' 	=> esc_html__('Rent Slider', 'autohive-core'),
					'carousel'	=> esc_html__('Rent Carousel', 'autohive-core'),
				],
				'default' => 'inventory',
			]
		);

		$this->end_controls_section(); //End Layout

		//======================== Filter Options 02, 03 ==========================//
		$this->start_controls_section(
			'filter',
			[
				'label' => __('Filter', 'autohive-core'),
			]
		);

		$this->add_control(
			'show_count',
			[
				'label' => esc_html__('Show Posts Count', 'autohive-core'),
				'type' => Controls_Manager::NUMBER,
				'default' => 4
			]
		);

		$this->add_control(
			'cats',
			[
				'label' => esc_html__('Category', 'autohive-core'),
				'type'      => Controls_Manager::SELECT2,
				'options'   => \Autohive_Core_Helper::get_the_category_array('autohive_rent_cat'),
				'label_block' => true,
				'multiple'  => true,
			]
		);

		$this->add_control(
			'title_limit_char',
			[
				'label' => esc_html__('Title Character Limit', 'autohive-core'),
				'type' => Controls_Manager::NUMBER,
				'default' => 20
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__('Order', 'autohive-core'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'ASC' => 'ASC',
					'DESC' => 'DESC'
				],
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'exclude',
			[
				'label' => esc_html__('Exclude Posts', 'autohive-core'),
				'description' => esc_html__('Enter the Listting post IDs to hide/exclude. Input the multiple ID with comma separated', 'autohive-core'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'button_label',
			[
				'label' => esc_html__('Order Now Button Label', 'autohive-core'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Order Now', 'autohive-core'),
			]
		);

		$this->end_controls_section(); //End Filter's

		/* Carousel Settings =================== */
		$this->start_controls_section(
			'slider_control_settings',[
				'label' => __('Carousel Settings', 'autohive-core'),
				'condition' => [
					'layout' => 'carousel'
				]
			]
		);

		$this->add_control(
			'show_items_desktop', [
				'label'     => esc_html__( 'Display Items [Desktop]', 'authohive-core' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 3,
			]
		);

		$this->add_control(
			'show_items_tablet', [
				'label'     => esc_html__( 'Display Items [Tablet]', 'authohive-core' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 2
			]
		);

		$this->add_control(
			'show_items_mobile', [
				'label'     => esc_html__( 'Display Items [Mobile]', 'authohive-core' ),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 1
			]
		);

		$this->add_control(
			'carousel_autoplay',
			[
				'label' => __('Auto Play', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __(
					'True',
					'autohive-core'
				),
				'label_off' => __('False', 'autohive-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'carousel_loop',
			[
				'label' => __('Loop',
					'autohive-core'
				),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __(
					'True',
					'autohive-core'
				),
				'label_off' => __('False', 'autohive-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'slide_speed',
			[
				'label' => esc_html__(
					'Slide Speed',
					'autohive-core'
				),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5000,
				'step' => 1,
				'default' => 1000
			]
		);
		$this->end_controls_section();
	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control()
	{
	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render()
	{

		$settings     = $this->get_settings_for_display();
		extract($settings);

		require __DIR__ . '/templates/listing-rent/rent-' . $layout . '.php';

	}
}
