<?php

namespace Autohive\Widgets;

if (!defined('ABSPATH')) {
	exit;
}

use Elementor\{
	Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils
};

class Autohive_Listing_Features extends Widget_Base
{

	public function get_name()
	{
		return 'autohive_listing_features';
	}

	public function get_title()
	{
		return esc_html__('Autohive Listing Features', 'autohive-core');
	}

	public function get_icon()
	{
		return 'eicon-table';
	}

	public function get_categories()
	{
		return ['autohive-elements'];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls()
	{
		$this->autohive_elementor_content_control();
		$this->autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control()
	{
		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout',
			[
				'label' => __('Layout', 'autohive-core'),
			]
		);

		$this->add_control(
			'layout_',
			[
				'label'   => esc_html__('Layout', 'autohive-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__('01 Layout ', 'autohive-core'),
					'2' => esc_html__('02 Layout ', 'autohive-core'),
				],
				'default' => '1',
			]
		);
		$this->end_controls_section();


		//=============================== Start Features ========================//
		$this->start_controls_section(
			'sec_features',
			[
				'label' => esc_html__('Features', 'autohive-core'),
				'condition' => [
					'layout_' => '1'
				]
			]
		);

		//========= Layout 01
		$feature = new \Elementor\Repeater();
		$feature->add_control(
			'meta_label',
			[
				'label'   => esc_html__('Meta Label', 'autohive-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => __('Body Type', 'autohive-core')

			]
		);
		$feature->add_control(
			'select_meta',
			[
				'label'   => esc_html__('Select Meta', 'autohive-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => autohive_listing_meta_features(),
				'default' => ''
			]
		);
		$feature->add_control(
			'icon_type',
			[
				'label'   => esc_html__('Select Icon Type', 'autohive-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'img'	=> __('Image', 'autohive-core'),
					'icon'	=> __('Icon', 'autohive-core'),
				],
				'default' => 'icon'

			]
		);
		$feature->add_control(
			'img_icon',
			[
				'label' => esc_html__('Icon Image', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'icon_type' => 'img'
				]
			]
		);
		$feature->add_control(
			'meta_icon',
			[
				'label' => esc_html__('Icon', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-circle',
					'library' => 'fa-solid',
				],
				'condition' => [
					'icon_type' => 'icon'
				]
			]
		);

		$this->add_control(
			'features',
			[
				'label' => esc_html__('Add Features', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $feature->get_controls(),
				'title_field' => '{{{ select_meta }}}',
				'prevent_empty' => false
			]
		);

		$this->end_controls_section(); //End Features

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control()
	{
	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render()
	{

		$settings     = $this->get_settings_for_display();
		extract($settings); 
		
		
		//=============== Template Parts ================//
		require __DIR__ . '/templates/listing-details-feature/layout-'.$layout_.'.php';

		

	}
}
