<?php

namespace Autohive\Widgets;

if (!defined('ABSPATH')) {
	exit;
}

use Autohive_Core_Helper;
use Elementor\{
	Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils
};

class Autohive_Listing_Details extends Widget_Base
{

	public function get_name()
	{
		return 'autohive_listing_details';
	}

	public function get_title()
	{
		return esc_html__('Autohive Listing Details', 'autohive-core');
	}

	public function get_icon()
	{
		return 'eicon-single-post';
	}

	public function get_categories()
	{
		return ['autohive-elements'];
	}

	public function get_script_depends()
	{
		return ['swiper'];
	}

	public function get_style_depends()
	{
		return ['swiper'];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls()
	{
		$this->autohive_elementor_content_control();
		$this->autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control()
	{
		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout',
			[
				'label' => __('Layout', 'autohive-core'),
			]
		);

		$this->add_control(
			'layout',
			[
				'label'   => esc_html__('Layout', 'autohive-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__('01: Thumbnail & Meta', 'autohive-core'),
					'2' => esc_html__('02: Price & Location ', 'autohive-core'),
					'dealer-meta' => esc_html__('03: Dealer Meta ', 'autohive-core'),
					'calculator' => esc_html__('04: Financing Calculator', 'autohive-core'),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//==================== Financing Calculator ==========================//
		$this->start_controls_section(
			'financing_calculator',
			[
				'label' => __('Calculator Input label', 'autohive-core'),
				'condition' => [
					'layout' => 'calculator'
				]
			]
		);
		
		$this->add_control(
			'currency',
			[
				'label' => __('Currency', 'autohive-core'),
				'type' => Controls_Manager::TEXT,			
				'default' => __('$', 'autohive-core'),
				
			]
		);

		$this->add_control(
			'vehicle_price',
			[
				'label' => __('Price', 'autohive-core'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Vehicle Price', 'autohive-core'),
			]
		);

		$this->add_control(
			'down_payment',
			[
				'label' => __('Down Payments', 'autohive-core'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Down Payments', 'autohive-core'),
			]
		);

		$this->add_control(
			'interest_rate',
			[
				'label' => __('Interest Rate', 'autohive-core'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Interest Rate', 'autohive-core'),

			]
		);

		$this->add_control(
			'no_of_month',
			[
				'label' => __('Number of Month', 'autohive-core'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Number of Month', 'autohive-core'),

			]
		);

		$this->end_controls_section(); //End Financing Calculator
	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {



	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {
		$settings     = $this->get_settings_for_display();
		extract($settings);

		//=============== Template Parts ================//
		if (is_singular([ 'autohive_listing', 'autohive_rent' ])) {
			require __DIR__ . '/templates/listing-details/layout-' . $layout . '.php';
		} else {
			echo '<h2>You can use this widget only for Listing Details page</h2>';
		}
	}
}