<?php

namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Border,
	Group_Control_Box_Shadow,
	Group_Control_Typography,
	Repeater,
	Icons_Manager,
	Widget_Base};

/**
 * Autohive Tab
 *
 * Autohive widget.
 *
 * @since 2.0.0
 */
class Autohive_Listing_Brands extends Widget_Base {

	public function get_name() {
		return 'autohive_listing_brands';
	}

	public function get_title() {
		return __( 'Autohive Listing Brand', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-tabs';
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {

		// Layout =====================
		$this->start_controls_section( 
			'section_layout', 
			[
				'label' => __( 'Select Layout', 'autohive-core' ),
			] 
		);

		$this->add_control( 
			'layout', 
			[
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( 'Body Types With Brand Tab', 'autohive-core' ),
					'2' => esc_html__( 'Body Types', 'autohive-core' ),
				],
				'default' => '1',
			] 
		);
		$this->end_controls_section();

		// ------------------------------ Feature list ------------------------------
		$this->start_controls_section( 'listing_brands_tab', [
			'label' => __( 'Listing Brand Options', 'autohive-core' ),
		] );
		$repeater = new Repeater();

		$repeater->add_control( 'select_brand', [
			'label'   => esc_html__( 'Select Brnad', 'autohive-core' ),
			'type'    => Controls_Manager::SELECT,
			'options' => autohive_cat_array( 'autohive_listing_brand' ),			
		] );

		$this->add_control( 'listing_brands', [
			'label'       => __( 'Listing Brands', 'autohive-core' ),
			'type'        => Controls_Manager::REPEATER,
			'fields'      => $repeater->get_controls(),
			'title_field' => '{{{select_brand}}}',
			'condition' => [
				'layout' => '1'
			]
		] );

		$this->add_control(
			'inventory_page_url',
			[
				'label' => __('Inventory Page URL', 'autohive-core'),
				'type' => Controls_Manager::URL,
			]
		);

		$this->end_controls_section();

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

	}


	protected function render() {

		$settings    = $this->get_settings();
		extract( $settings ); 
		
		require __DIR__ . '/templates/listing-brands/layout-' . $layout . '.php';

	}
}


